/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.search.arguments;

import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import java.util.ArrayList;
import java.util.List;

public class SpellCheckArgs<K, V> {
    private Long distance;
    private Long dialect;
    private final List<TermsClause<K, V>> termsClauses = new ArrayList<TermsClause<K, V>>();

    public SpellCheckArgs<K, V> distance(long distance) {
        this.distance = distance;
        return this;
    }

    public SpellCheckArgs<K, V> dialect(long dialect) {
        this.dialect = dialect;
        return this;
    }

    @SafeVarargs
    public final SpellCheckArgs<K, V> termsInclude(K dictionary, V ... terms) {
        this.termsClauses.add(new TermsClause<K, V>(TermsClause.Type.INCLUDE, dictionary, terms));
        return this;
    }

    @SafeVarargs
    public final SpellCheckArgs<K, V> termsExclude(K dictionary, V ... terms) {
        this.termsClauses.add(new TermsClause<K, V>(TermsClause.Type.EXCLUDE, dictionary, terms));
        return this;
    }

    public void build(CommandArgs<K, V> args) {
        if (this.distance != null) {
            args.add(CommandKeyword.DISTANCE).add(this.distance);
        }
        for (TermsClause<K, V> clause : this.termsClauses) {
            clause.build(args);
        }
        if (this.dialect != null) {
            args.add(CommandKeyword.DIALECT).add(this.dialect);
        }
    }

    private static class TermsClause<K, V> {
        private final Type type;
        private final K dictionary;
        private final V[] terms;

        @SafeVarargs
        TermsClause(Type type, K dictionary, V ... terms) {
            this.type = type;
            this.dictionary = dictionary;
            this.terms = terms;
        }

        void build(CommandArgs<K, V> args) {
            args.add(CommandKeyword.TERMS).add(this.type.name()).addKey(this.dictionary);
            if (this.terms != null) {
                for (V term : this.terms) {
                    args.addValue(term);
                }
            }
        }

        static enum Type {
            INCLUDE,
            EXCLUDE;

        }
    }

    public static class Builder {
        private Builder() {
        }

        public static <K, V> SpellCheckArgs<K, V> distance(long distance) {
            return new SpellCheckArgs().distance(distance);
        }

        public static <K, V> SpellCheckArgs<K, V> dialect(long dialect) {
            return new SpellCheckArgs().dialect(dialect);
        }

        @SafeVarargs
        public static <K, V> SpellCheckArgs<K, V> termsInclude(K dictionary, V ... terms) {
            return new SpellCheckArgs<K, V>().termsInclude(dictionary, terms);
        }

        @SafeVarargs
        public static <K, V> SpellCheckArgs<K, V> termsExclude(K dictionary, V ... terms) {
            return new SpellCheckArgs<K, V>().termsExclude(dictionary, terms);
        }
    }
}

