/*
 * Decompiled with CFR 0.152.
 */
package mc.obliviate.inventory;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mc.obliviate.inventory.GuiIcon;
import mc.obliviate.inventory.Icon;
import mc.obliviate.inventory.InventoryAPI;
import mc.obliviate.inventory.event.customclosevent.FakeInventoryCloseEvent;
import mc.obliviate.inventory.util.NMSUtil;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public abstract class Gui
implements InventoryHolder {
    private final Map<Integer, GuiIcon> registeredIcons;
    private final List<BukkitTask> taskList = new ArrayList<BukkitTask>();
    private final String id;
    private final InventoryType inventoryType;
    public final Player player;
    private Inventory inventory;
    private String title;
    private int size;
    private boolean isClosed = false;

    public Gui(@Nonnull Player player, @Nonnull String id, String title, @Nonnegative int rows) {
        this.registeredIcons = new HashMap<Integer, GuiIcon>(rows * 9);
        this.player = player;
        this.size = rows * 9;
        this.title = title;
        this.id = id;
        this.inventoryType = InventoryType.CHEST;
    }

    public Gui(@Nonnull Player player, @Nonnull String id, String title, InventoryType inventoryType) {
        this.registeredIcons = new HashMap<Integer, GuiIcon>(inventoryType.getDefaultSize());
        this.player = player;
        this.size = inventoryType.getDefaultSize();
        this.title = title;
        this.id = id;
        this.inventoryType = inventoryType;
    }

    public Gui(@Nonnull Player player, @Nonnull String id, Component title, @Nonnegative int rows) {
        this(player, id, NMSUtil.LEGACY.serialize(title), rows);
    }

    public Gui(@Nonnull Player player, @Nonnull String id, Component title, InventoryType inventoryType) {
        this(player, id, NMSUtil.LEGACY.serialize(title), inventoryType);
    }

    @Nonnull
    public Plugin getPlugin() {
        return InventoryAPI.getInstance().getPlugin();
    }

    public boolean onClick(InventoryClickEvent event) {
        return false;
    }

    public boolean onDrag(InventoryDragEvent event) {
        return false;
    }

    public void onOpen(InventoryOpenEvent event) {
    }

    public void onClose(InventoryCloseEvent event) {
        if (event instanceof FakeInventoryCloseEvent) {
            return;
        }
        Gui gui = InventoryAPI.getInstance().getGuiFromInventory(event.getPlayer().getOpenInventory().getTopInventory());
        if (gui == null) {
            return;
        }
        if (!gui.equals(this)) {
            return;
        }
        gui.stopAllTasks();
    }

    public void open() {
        Preconditions.checkNotNull(InventoryAPI.getInstance(), "Inventory API is not initialized. Please use new InventoryAPI().init() also, you can visit wiki of obliviate-invs.");
        Gui gui = InventoryAPI.getInstance().getPlayersCurrentGui(this.player);
        if (gui != null) {
            Bukkit.getPluginManager().callEvent((Event)new FakeInventoryCloseEvent(this.player.getOpenInventory()));
        }
        InventoryAPI.getInstance().getPlayers().put(this.player.getUniqueId(), this);
        this.inventory = this.inventoryType.equals((Object)InventoryType.CHEST) ? Bukkit.createInventory(null, (int)this.size, (String)this.title) : Bukkit.createInventory(null, (InventoryType)this.inventoryType, (String)this.title);
        this.player.openInventory(this.inventory);
    }

    public void fillGui(GuiIcon icon) {
        for (int slot = 0; slot < this.size; ++slot) {
            this.addItem(slot, icon);
        }
    }

    public void fillGui(ItemStack item) {
        this.fillGui(new Icon(item));
    }

    public void fillGui(Material material) {
        this.fillGui(new Icon(material));
    }

    public void fillGui(GuiIcon icon, Iterable<Integer> blacklisted_slots) {
        for (int slot = 0; slot < this.size; ++slot) {
            if (this.checkContainsInt(slot, blacklisted_slots)) continue;
            this.addItem(slot, icon);
        }
    }

    public void fillRow(GuiIcon item, @Nonnegative int row) {
        Preconditions.checkArgument(row < this.size / 9);
        for (int i = 0; i < 9; ++i) {
            this.addItem(row * 9 + i, item);
        }
    }

    public void fillColumn(GuiIcon item, @Nonnegative int column) {
        Preconditions.checkArgument(column < 9);
        for (int i = 0; i < 9; ++i) {
            this.addItem(i * 9 + column, item);
        }
    }

    public void addItem(@Nonnegative int slot, @Nullable GuiIcon icon) {
        if (this.inventory.getSize() <= slot) {
            throw new IndexOutOfBoundsException("Slot cannot be bigger than inventory size! [ " + slot + " >= " + this.inventory.getSize() + " ]");
        }
        this.registeredIcons.put(slot, icon);
        this.inventory.setItem(slot, icon == null ? null : icon.getItem());
    }

    public void addItem(@Nullable GuiIcon item, Integer ... slots) {
        Integer[] integerArray = slots;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int slot = integerArray[i];
            this.addItem(slot, item);
        }
    }

    public void addItem(@Nullable GuiIcon icon, @Nonnull Iterable<Integer> slots) {
        for (Integer slot : slots) {
            this.addItem((int)slot, icon);
        }
    }

    public void addItem(@Nonnegative int slot, @Nullable ItemStack item) {
        this.addItem(slot, new Icon(item));
    }

    public void addItem(@Nonnull GuiIcon icon) {
        this.addItem(this.inventory.firstEmpty(), icon);
    }

    public void addItem(@Nullable ItemStack item) {
        this.addItem(this.inventory.firstEmpty(), new Icon(item));
    }

    public void addItem(@Nonnull Material material) {
        this.addItem(this.inventory.firstEmpty(), new Icon(material));
    }

    public void addItem(@Nonnegative int slot, Material material) {
        this.addItem(slot, new Icon(material));
    }

    public void updateTask(@Nonnegative long runDelayInTicks, @Nonnegative long periodInTicks, @Nonnull Consumer<BukkitTask> update) {
        Preconditions.checkNotNull(InventoryAPI.getInstance(), "InventoryAPI is not initialized.");
        BukkitTask[] bukkitTask = new BukkitTask[]{null};
        bukkitTask[0] = Bukkit.getScheduler().runTaskTimer(this.getPlugin(), () -> update.accept(bukkitTask[0]), runDelayInTicks, periodInTicks);
        this.taskList.add(bukkitTask[0]);
    }

    public void runTaskLater(@Nonnegative long runDelayInTicks, @Nonnull Consumer<BukkitTask> update) {
        Preconditions.checkNotNull(InventoryAPI.getInstance(), "InventoryAPI is not initialized.");
        BukkitTask[] bukkitTask = new BukkitTask[]{null};
        bukkitTask[0] = Bukkit.getScheduler().runTaskLater(this.getPlugin(), () -> update.accept(bukkitTask[0]), runDelayInTicks);
        this.taskList.add(bukkitTask[0]);
    }

    @Nonnull
    public Map<Integer, GuiIcon> getItems() {
        return this.registeredIcons;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public Inventory getInventory() {
        return this.inventory;
    }

    @Nullable
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void sendTitleUpdate(@Nonnull String title) {
        this.title = Objects.requireNonNull(title, "title cannot be null!");
        this.open();
    }

    public void sendSizeUpdate(@Nonnegative int sizeUpdate) {
        this.size = sizeUpdate;
        this.open();
    }

    public int getSize() {
        return this.size;
    }

    public int getLastSlot() {
        return this.size - 1;
    }

    public void setSize(@Nonnegative int size) {
        this.size = size;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void setClosed(boolean closed) {
        this.isClosed = closed;
    }

    public List<BukkitTask> getTaskList() {
        return Collections.unmodifiableList(this.taskList);
    }

    public void stopTask(@Nonnull BukkitTask task) {
        Preconditions.checkNotNull(task, "task cannot be null");
        task.cancel();
        this.taskList.remove(task);
    }

    public void stopAllTasks() {
        this.taskList.forEach(BukkitTask::cancel);
        this.taskList.clear();
    }

    private boolean checkContainsInt(int i, Iterable<Integer> ints) {
        for (int number : ints) {
            if (number != i) continue;
            return true;
        }
        return false;
    }
}

