/*
 * Decompiled with CFR 0.152.
 */
package mc.obliviate.inventory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import mc.obliviate.inventory.ComponentIcon;
import mc.obliviate.inventory.GuiIcon;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class Icon
implements GuiIcon {
    private final ItemStack item;
    private Consumer<InventoryClickEvent> clickAction;
    private Consumer<InventoryDragEvent> dragAction;

    public Icon(ItemStack item) {
        this.item = item;
        this.dragAction = event -> {};
        this.clickAction = event -> {};
    }

    public Icon(Material material) {
        this(new ItemStack(material));
    }

    public ComponentIcon toComp() {
        return ComponentIcon.fromIcon(this);
    }

    @Nonnull
    public Icon setDurability(short newDamage) {
        this.item.setDurability(newDamage);
        return this;
    }

    @Nonnull
    public Icon setDurability(int newDamage) {
        this.setDurability((short)newDamage);
        return this;
    }

    @Nonnull
    public Icon setName(String name) {
        ItemMeta meta = this.item.getItemMeta();
        if (meta == null) {
            return this;
        }
        meta.setDisplayName(name);
        this.item.setItemMeta(meta);
        return this;
    }

    @Nonnull
    public Icon setLore(List<String> lore) {
        ItemMeta meta = this.item.getItemMeta();
        if (meta == null) {
            return this;
        }
        meta.setLore(lore);
        this.item.setItemMeta(meta);
        return this;
    }

    @Nonnull
    public Icon setLore(String ... lore) {
        return this.setLore(new ArrayList<String>(Arrays.asList(lore)));
    }

    @Nonnull
    public Icon appendLore(List<String> newLines) {
        ItemMeta meta = this.item.getItemMeta();
        if (meta == null) {
            return this;
        }
        List<String> lore = meta.getLore();
        if (lore != null) {
            lore.addAll(newLines);
        } else {
            lore = newLines;
        }
        return this.setLore(lore);
    }

    @Nonnull
    public Icon appendLore(String ... newLines) {
        return this.appendLore(new ArrayList<String>(Arrays.asList(newLines)));
    }

    @Nonnull
    public Icon insertLore(int index, String ... newLines) {
        return this.insertLore(index, new ArrayList<String>(Arrays.asList(newLines)));
    }

    @Nonnull
    public Icon insertLore(int index, List<String> newLines) {
        ItemMeta meta = this.item.getItemMeta();
        if (meta == null) {
            return this;
        }
        List<String> lore = meta.getLore();
        if (lore != null) {
            lore.addAll(index, newLines);
        } else {
            lore = newLines;
        }
        return this.setLore(lore);
    }

    @Nonnull
    public Icon setAmount(int amount) {
        this.item.setAmount(amount);
        return this;
    }

    @Nonnull
    public Icon hideFlags(ItemFlag ... itemFlag) {
        ItemMeta meta = this.item.getItemMeta();
        if (meta == null) {
            return this;
        }
        meta.addItemFlags(itemFlag);
        this.item.setItemMeta(meta);
        return this;
    }

    @Nonnull
    public Icon hideFlags() {
        this.hideFlags(ItemFlag.values());
        return this;
    }

    @Nonnull
    public Icon enchant(Enchantment enchantment) {
        return this.enchant(enchantment, enchantment.getStartLevel());
    }

    @Nonnull
    public Icon enchant(Map<Enchantment, Integer> enchantments) {
        for (Map.Entry<Enchantment, Integer> enchant : enchantments.entrySet()) {
            this.enchant(enchant.getKey(), enchant.getValue());
        }
        return this;
    }

    @Nonnull
    public Icon enchant(Enchantment enchantment, int level) {
        if (this.item.getType().equals((Object)Material.ENCHANTED_BOOK)) {
            EnchantmentStorageMeta meta = (EnchantmentStorageMeta)this.item.getItemMeta();
            if (meta == null) {
                return this;
            }
            meta.addStoredEnchant(enchantment, level, true);
            this.item.setItemMeta((ItemMeta)meta);
        } else {
            this.item.addUnsafeEnchantment(enchantment, level);
        }
        return this;
    }

    @Override
    @Nonnull
    public Consumer<InventoryClickEvent> getClickAction() {
        return this.clickAction;
    }

    @Nonnull
    public Icon onClick(Consumer<InventoryClickEvent> clickAction) {
        this.clickAction = clickAction;
        return this;
    }

    @Override
    @Nonnull
    public Consumer<InventoryDragEvent> getDragAction() {
        return this.dragAction;
    }

    @Nonnull
    public Icon onDrag(Consumer<InventoryDragEvent> dragAction) {
        this.dragAction = dragAction;
        return this;
    }

    @Override
    public ItemStack getItem() {
        return this.item;
    }
}

