/*
 * Decompiled with CFR 0.152.
 */
package mc.obliviate.inventory;

import java.util.Iterator;
import mc.obliviate.inventory.Gui;
import mc.obliviate.inventory.GuiIcon;
import mc.obliviate.inventory.InventoryAPI;
import mc.obliviate.inventory.event.GuiPreClickEvent;
import mc.obliviate.inventory.event.GuiPreCloseEvent;
import mc.obliviate.inventory.event.GuiPreDragEvent;
import mc.obliviate.inventory.event.GuiPreOpenEvent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;

public class InvListener
implements Listener {
    private final InventoryAPI inventoryAPI;

    protected InvListener(InventoryAPI inventoryAPI) {
        this.inventoryAPI = inventoryAPI;
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Gui openGui = this.inventoryAPI.getPlayersCurrentGui((Player)event.getWhoClicked());
        if (openGui == null) {
            return;
        }
        if (InvListener.callAndCheckCancel(new GuiPreClickEvent(event, openGui))) {
            return;
        }
        boolean doNotProtect = openGui.onClick(event);
        int index = event.getRawSlot();
        if (!doNotProtect) {
            if (event.getSlot() == index) {
                event.setCancelled(true);
            } else {
                switch (event.getAction()) {
                    case MOVE_TO_OTHER_INVENTORY: 
                    case COLLECT_TO_CURSOR: 
                    case UNKNOWN: {
                        event.setCancelled(true);
                    }
                }
            }
        } else {
            event.setCancelled(false);
        }
        GuiIcon item = openGui.getItems().get(index);
        if (item == null) {
            return;
        }
        item.getClickAction().accept(event);
    }

    @EventHandler
    public void onClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        Gui openGui = this.inventoryAPI.getPlayersCurrentGui(player);
        if (openGui == null) {
            return;
        }
        if (!event.getInventory().equals(openGui.getInventory())) {
            return;
        }
        if (InvListener.callAndCheckCancel(new GuiPreCloseEvent(event, openGui))) {
            return;
        }
        openGui.onClose(event);
        openGui.setClosed(true);
        this.inventoryAPI.getPlayers().remove(player.getUniqueId());
    }

    @EventHandler
    public void onDrag(InventoryDragEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Gui openGui = this.inventoryAPI.getPlayersCurrentGui(player);
        if (openGui == null) {
            return;
        }
        if (InvListener.callAndCheckCancel(new GuiPreDragEvent(event, openGui))) {
            return;
        }
        event.setCancelled(!openGui.onDrag(event));
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            GuiIcon item = openGui.getItems().get(index);
            if (item == null) {
                return;
            }
            item.getDragAction().accept(event);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onOpen(InventoryOpenEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        Gui openGui = this.inventoryAPI.getPlayersCurrentGui(player);
        if (openGui == null) {
            return;
        }
        if (InvListener.callAndCheckCancel(new GuiPreOpenEvent(event, openGui))) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        openGui.onOpen(event);
    }

    private static boolean callAndCheckCancel(Event event) {
        Bukkit.getPluginManager().callEvent(event);
        return event instanceof Cancellable && ((Cancellable)event).isCancelled();
    }
}

