/*
 * Decompiled with CFR 0.152.
 */
package mc.obliviate.util.versiondetection;

public enum ServerVersionController {
    UNKNOWN,
    OUTDATED,
    V1_5,
    V1_6,
    V1_7,
    V1_8,
    V1_9,
    V1_10,
    V1_11,
    V1_12,
    V1_13,
    V1_14,
    V1_15,
    V1_16,
    V1_17,
    V1_18,
    V1_19,
    V1_20,
    V1_21,
    V1_22,
    V1_23,
    V1_24,
    NEWER;

    private static ServerVersionController serverVersion;

    public static boolean isServerVersionAbove(ServerVersionController version) {
        return ServerVersionController.getServerVersion().ordinal() > version.ordinal();
    }

    public static boolean isServerVersionAtLeast(ServerVersionController version) {
        return ServerVersionController.getServerVersion().ordinal() >= version.ordinal();
    }

    public static boolean isServerVersionAtOrBelow(ServerVersionController version) {
        return ServerVersionController.getServerVersion().ordinal() <= version.ordinal();
    }

    public static boolean isServerVersionBelow(ServerVersionController version) {
        return ServerVersionController.getServerVersion().ordinal() < version.ordinal();
    }

    public static ServerVersionController getServerVersion() {
        if (serverVersion == null) {
            ServerVersionController.calculateServerVersion(ServerVersionController.findServerInstance());
        }
        return serverVersion;
    }

    public static void calculateServerVersion(Object server) {
        if (server == null) {
            serverVersion = UNKNOWN;
            return;
        }
        Class<?> serverClazz = server.getClass();
        String packageName = serverClazz.getPackage().getName();
        try {
            String version = packageName.substring(packageName.lastIndexOf(46) + 1);
            String rawVersion = version.split("_")[1];
            serverVersion = ServerVersionController.matchServerVersion(Integer.parseInt(rawVersion));
        }
        catch (Exception ignore) {
            serverVersion = UNKNOWN;
        }
    }

    public static void setServerVersion(ServerVersionController serverVersion) {
        ServerVersionController.serverVersion = serverVersion;
    }

    private static ServerVersionController matchServerVersion(int rawVersion) {
        if (rawVersion < 5) {
            return OUTDATED;
        }
        if (rawVersion > ServerVersionController.values().length + 2) {
            return NEWER;
        }
        return ServerVersionController.valueOf("V1_" + rawVersion);
    }

    private static Object findServerInstance() {
        try {
            return Class.forName("org.bukkit.Bukkit").getMethod("getServer", new Class[0]).invoke(null, (Object[])null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString() {
        return this.name();
    }
}

