/*
 * Decompiled with CFR 0.152.
 */
package net.streamline.apib.depends;

import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import net.streamline.apib.SLAPIB;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import singularity.configs.given.MainMessagesHandler;
import singularity.data.players.CosmicPlayer;
import singularity.holders.CosmicDependencyHolder;
import singularity.modules.ModuleUtils;
import singularity.utils.MessageUtils;

public class PAPIDepend
extends CosmicDependencyHolder<PlaceholderAPI> {
    private StreamlinePAPIExpansion papiExpansion;

    public PAPIDepend() {
        super("PlaceholderAPI", "PlaceholderAPI", "papi", "placeholderapi");
        if (this.isPresent()) {
            this.setPapiExpansion(new StreamlinePAPIExpansion());
        } else {
            MessageUtils.logInfo("Could not find PlaceholderAPI... Disabling support...!");
        }
    }

    public void setPapiExpansion(StreamlinePAPIExpansion papiExpansion) {
        this.papiExpansion = papiExpansion;
    }

    public StreamlinePAPIExpansion getPapiExpansion() {
        return this.papiExpansion;
    }

    public static class StreamlinePAPIExpansion
    extends PlaceholderExpansion {
        public StreamlinePAPIExpansion() {
            if (this.register()) {
                MessageUtils.logInfo("Streamline PAPI Expansion loaded!");
            }
        }

        @NotNull
        public String getIdentifier() {
            return "streamline";
        }

        public boolean persist() {
            return true;
        }

        @NotNull
        public String getAuthor() {
            return "Drak";
        }

        @NotNull
        public String getVersion() {
            return SLAPIB.getPlugin().getDescription().getVersion();
        }

        public boolean register() {
            return super.register();
        }

        @Nullable
        public String onRequest(OfflinePlayer player, @NotNull String params) {
            CosmicPlayer streamPlayer = ModuleUtils.getOrCreatePlayer(player.getUniqueId().toString()).orElse(null);
            if (streamPlayer == null) {
                return MainMessagesHandler.MESSAGES.DEFAULTS.PLACEHOLDERS.IS_NULL.get();
            }
            String toParse = params.startsWith("!") ? "%" + params.substring("!".length()) + "%" : "%streamline_" + params + "%";
            return ModuleUtils.replaceAllPlayerBungee(streamPlayer, toParse);
        }
    }
}

