/*
 * Decompiled with CFR 0.152.
 */
package singularity.command;

import gg.drak.thebase.lib.leonhard.storage.Config;
import java.io.File;
import java.util.concurrent.ConcurrentSkipListSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import singularity.Singularity;
import singularity.command.CommandHandler;
import singularity.command.context.CommandArgument;
import singularity.command.context.CommandContext;
import singularity.command.result.CommandResult;
import singularity.configs.CommandResource;
import singularity.configs.given.MainMessagesHandler;
import singularity.data.console.CosmicSender;
import singularity.events.command.CommandResultedEvent;
import singularity.modules.ModuleUtils;

public abstract class CosmicCommand
implements Comparable<CosmicCommand> {
    private String identifier;
    private String label;
    private String base;
    private String permission;
    private String[] aliases;
    private final CommandResource commandResource;

    public CosmicCommand(String label, String base, String permission, File parentDirectory, String ... aliases) {
        this.label = label;
        this.identifier = base;
        this.base = base;
        this.permission = permission;
        this.aliases = aliases;
        this.commandResource = new CommandResource(this, parentDirectory);
    }

    public CosmicCommand(String label, String base, String permission, String ... aliases) {
        this(label, base, permission, Singularity.getMainCommandsFolder(), aliases);
    }

    public void register() {
        if (!this.isEnabled()) {
            return;
        }
        CommandHandler.registerStreamlineCommand(this);
    }

    public void unregister() {
        if (!this.isEnabled() && !CommandHandler.isStreamlineCommandRegistered(this.getIdentifier())) {
            return;
        }
        CommandHandler.unregisterStreamlineCommand(this);
    }

    public CommandResult<?> baseRun(CosmicSender sender, @Nullable String[] args) {
        CommandContext<CosmicCommand> context;
        CommandResult<?> result;
        if (!sender.hasPermission(this.getPermission())) {
            sender.sendMessage(MainMessagesHandler.MESSAGES.INVALID.PERMISSIONS.get());
            return CommandResult.Failure.get();
        }
        if (args == null) {
            args = new String[]{""};
        }
        if (args.length < 1) {
            args = new String[]{""};
        }
        if ((result = this.resultedRun(context = new CommandContext<CosmicCommand>(sender, this, CosmicCommand.notSet(), args))) != null) {
            context.setResult(result);
        }
        CommandResultedEvent<CosmicCommand> event = new CommandResultedEvent<CosmicCommand>(context);
        event.fire();
        return context.getResult();
    }

    @Deprecated
    public void run(CosmicSender sender, @Nullable String[] args) {
    }

    @Deprecated
    public void run(CommandContext<CosmicCommand> context) {
        this.run(context.getSender(), (String[])context.getArgs().stream().map(CommandArgument::getContent).toArray(String[]::new));
    }

    public CommandResult<?> resultedRun(CommandContext<CosmicCommand> context) {
        this.run(context);
        return null;
    }

    public ConcurrentSkipListSet<String> baseTabComplete(CosmicSender sender, @Nullable String[] args) {
        if (!sender.hasPermission(this.getPermission())) {
            return new ConcurrentSkipListSet<String>();
        }
        if (args == null) {
            args = new String[]{""};
        }
        if (args.length < 1) {
            args = new String[]{""};
        }
        return this.doTabComplete(new CommandContext<CosmicCommand>(sender, this, CosmicCommand.notSet(), args));
    }

    @Deprecated
    public ConcurrentSkipListSet<String> doTabComplete(CosmicSender sender, @Nullable String[] args) {
        return new ConcurrentSkipListSet<String>();
    }

    public ConcurrentSkipListSet<String> doTabComplete(CommandContext<CosmicCommand> context) {
        return this.doTabComplete(context.getSender(), (String[])context.getArgs().stream().map(CommandArgument::getContent).toArray(String[]::new));
    }

    public String getWithOther(CosmicSender sender, String base, CosmicSender other) {
        base = base.replace("%this_other%", other.getCurrentName());
        base = base.replace("%this_other_uuid%", other.getUuid());
        return ModuleUtils.replacePlaceholders(other, this.getWithOther(sender, base, other.getCurrentName()));
    }

    public String getWithOther(CosmicSender sender, String base, String other) {
        base = base.replace("%this_sender%", sender.getCurrentName());
        base = base.replace("%this_sender_uuid%", sender.getUuid());
        return ModuleUtils.replacePlaceholders(sender, this.getWithOther(base, other));
    }

    public String getWithOther(String base, String other) {
        return base.replace("%this_other%", other);
    }

    public boolean isLoaded() {
        return CommandHandler.isStreamlineCommandRegistered(this.getIdentifier());
    }

    public boolean isEnabled() {
        return ((Config)this.getCommandResource().getResource()).getBoolean("basic.enabled");
    }

    public void disable() {
        CommandHandler.unregisterStreamlineCommand(this);
    }

    @Override
    public int compareTo(@NotNull CosmicCommand o) {
        return CharSequence.compare(this.getIdentifier(), o.getIdentifier());
    }

    public ConcurrentSkipListSet<String> getIntegerArgument() {
        return this.getIntegerArgument(-5, 5);
    }

    public ConcurrentSkipListSet<String> getIntegerArgument(int min2, int max) {
        if (min2 > max) {
            int temp = min2;
            min2 = max;
            max = temp;
        }
        ConcurrentSkipListSet<String> r = new ConcurrentSkipListSet<String>();
        for (int i = min2; i <= max; ++i) {
            r.add(String.valueOf(i));
        }
        return r;
    }

    public ConcurrentSkipListSet<String> getDoubleArgument() {
        return this.getDoubleArgument(-3.0, 3.0, 0.25);
    }

    public ConcurrentSkipListSet<String> getDoubleArgument(double min2, double max, double step) {
        if (min2 > max) {
            double temp = min2;
            min2 = max;
            max = temp;
        }
        ConcurrentSkipListSet<String> r = new ConcurrentSkipListSet<String>();
        for (double i = min2; i <= max; i += step) {
            r.add(String.valueOf(i));
        }
        r.add(String.valueOf(max));
        return r;
    }

    public static <T> CommandResult<T> result(String key, T result) {
        return new CommandResult<T>(key, result);
    }

    public static CommandResult.Success success() {
        return CommandResult.Success.get();
    }

    public static CommandResult.Failure failure() {
        return CommandResult.Failure.get();
    }

    public static CommandResult.Error error() {
        return CommandResult.Error.get();
    }

    public static CommandResult.NotSet notSet() {
        return CommandResult.NotSet.get();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getLabel() {
        return this.label;
    }

    public String getBase() {
        return this.base;
    }

    public String getPermission() {
        return this.permission;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public CommandResource getCommandResource() {
        return this.commandResource;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public void setAliases(String[] aliases) {
        this.aliases = aliases;
    }
}

