/*
 * Decompiled with CFR 0.152.
 */
package singularity.configs.given;

import gg.drak.thebase.lib.leonhard.storage.Config;
import gg.drak.thebase.storage.resources.flat.simple.SimpleConfiguration;
import singularity.Singularity;
import singularity.database.ConnectorSet;
import singularity.database.DatabaseType;

public class DatabaseConfigHandler
extends SimpleConfiguration {
    public DatabaseConfigHandler() {
        super("database-config.yml", Singularity.getInstance(), true);
    }

    public void init() {
        this.getDatabaseHost();
        this.getDatabasePort();
        this.getDatabaseUsername();
        this.getDatabasePassword();
        this.getDatabaseTablePrefix();
        this.getDatabaseName();
        this.getDatabaseType();
        this.getSqliteFileName();
    }

    public String getDatabaseHost() {
        this.reloadResource();
        return (String)((Config)this.getResource()).getOrSetDefault("host", (Object)"localhost");
    }

    public int getDatabasePort() {
        this.reloadResource();
        return (Integer)((Config)this.getResource()).getOrSetDefault("port", (Object)3306);
    }

    public String getDatabaseUsername() {
        this.reloadResource();
        return (String)((Config)this.getResource()).getOrSetDefault("username", (Object)"root");
    }

    public String getDatabasePassword() {
        this.reloadResource();
        return (String)((Config)this.getResource()).getOrSetDefault("password", (Object)"password");
    }

    public String getDatabaseTablePrefix() {
        this.reloadResource();
        return (String)((Config)this.getResource()).getOrSetDefault("table-prefix", (Object)"sl_");
    }

    public String getDatabaseName() {
        this.reloadResource();
        return (String)((Config)this.getResource()).getOrSetDefault("database", (Object)"streamline");
    }

    public DatabaseType getDatabaseType() {
        this.reloadResource();
        return DatabaseType.valueOf((String)((Config)this.getResource()).getOrSetDefault("type", (Object)DatabaseType.SQLITE.name()));
    }

    public String getSqliteFileName() {
        this.reloadResource();
        return (String)((Config)this.getResource()).getOrSetDefault("sqlite-file-name", (Object)"streamline.db");
    }

    public ConnectorSet getConnectorSet() {
        return new ConnectorSet(this.getDatabaseType(), this.getDatabaseHost(), this.getDatabasePort(), this.getDatabaseName(), this.getDatabaseUsername(), this.getDatabasePassword(), this.getDatabaseTablePrefix(), this.getSqliteFileName());
    }
}

