/*
 * Decompiled with CFR 0.152.
 */
package singularity.logging;

import gg.drak.thebase.events.processing.BaseProcessor;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import singularity.events.server.CosmicLogPopEvent;
import singularity.events.server.ServerLogTextEvent;
import singularity.listeners.CosmicListener;
import singularity.logging.timers.LogPopTimer;
import singularity.utils.MessageUtils;

public class LogCollector
extends CosmicListener {
    private static ConcurrentSkipListMap<Integer, ServerLogTextEvent> logQueue = new ConcurrentSkipListMap();
    private static AtomicInteger idCounter = new AtomicInteger(0);
    private static LogCollector instance;
    private static LogPopTimer logPopTimer;

    public static int getNextId() {
        return idCounter.getAndIncrement();
    }

    public static void addLog(ServerLogTextEvent event) {
        LogCollector.getLogQueue().put(LogCollector.getNextId(), event);
    }

    public static ConcurrentSkipListMap<Integer, ServerLogTextEvent> getLogs() {
        ConcurrentSkipListMap<Integer, ServerLogTextEvent> logs = new ConcurrentSkipListMap<Integer, ServerLogTextEvent>((SortedMap<Integer, ServerLogTextEvent>)LogCollector.getLogQueue());
        LogCollector.resetQueue();
        return logs;
    }

    public static void resetQueue() {
        LogCollector.clearLogs();
        LogCollector.setIdCounter(new AtomicInteger(0));
    }

    public static void clearLogs() {
        logQueue.clear();
    }

    public static void init() {
        LogCollector.setInstance(new LogCollector());
        LogCollector.setLogPopTimer(new LogPopTimer());
        MessageUtils.logInfo("LogCollector initialized. Listening for log events.");
    }

    public static void popAndEvent() {
        ConcurrentSkipListMap<Integer, ServerLogTextEvent> logs = LogCollector.getLogs();
        if (!logs.isEmpty()) {
            CosmicLogPopEvent cosmicLogPopEvent = (CosmicLogPopEvent)new CosmicLogPopEvent(logs).fire();
        }
    }

    @BaseProcessor
    public void onServerLogTextEvent(ServerLogTextEvent event) {
        LogCollector.addLog(event);
    }

    public static ConcurrentSkipListMap<Integer, ServerLogTextEvent> getLogQueue() {
        return logQueue;
    }

    public static void setLogQueue(ConcurrentSkipListMap<Integer, ServerLogTextEvent> logQueue) {
        LogCollector.logQueue = logQueue;
    }

    public static AtomicInteger getIdCounter() {
        return idCounter;
    }

    public static void setIdCounter(AtomicInteger idCounter) {
        LogCollector.idCounter = idCounter;
    }

    public static LogCollector getInstance() {
        return instance;
    }

    public static void setInstance(LogCollector instance) {
        LogCollector.instance = instance;
    }

    public static LogPopTimer getLogPopTimer() {
        return logPopTimer;
    }

    public static void setLogPopTimer(LogPopTimer logPopTimer) {
        LogCollector.logPopTimer = logPopTimer;
    }
}

