/*
 * Decompiled with CFR 0.152.
 */
package singularity.messages.proxied;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import gg.drak.thebase.lib.re2j.Matcher;
import gg.drak.thebase.utils.MatcherUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import singularity.Singularity;
import singularity.data.players.CosmicPlayer;
import singularity.data.server.CosmicServer;
import singularity.messages.answered.ReturnableMessage;
import singularity.objects.SingleSet;

public class ProxiedMessage
implements Comparable<ProxiedMessage> {
    private final String defaultListSeparator = "{{,}}";
    private final String argumentKeyMaster = "{{arg[%index%]}}";
    private final String subChannelKey = "{{sub-channel}}";
    private ConcurrentSkipListMap<Integer, SingleSet<String, String>> arguments = new ConcurrentSkipListMap();
    private ConcurrentSkipListMap<String, String> literalContents = new ConcurrentSkipListMap();
    private final CosmicPlayer carrier;
    private final boolean proxyOriginated;
    private final String mainChannel;
    private final Date gottenAt;

    public void setSubChannel(String subChannel) {
        this.write(this.getSubChannelKey(), subChannel);
    }

    public String getSubChannel() {
        return this.getString(this.getSubChannelKey());
    }

    public String getLiteralAsString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getSubChannel()).append("->");
        this.getLiteralContents().forEach((key, value) -> builder.append(this.getJustifiedContent((String)key, (String)value)));
        return builder.toString();
    }

    public ProxiedMessage(CosmicPlayer carrier, boolean proxyOriginated, String mainChannel) {
        this.carrier = carrier;
        this.proxyOriginated = proxyOriginated;
        this.mainChannel = mainChannel;
        this.gottenAt = new Date();
    }

    public ProxiedMessage(CosmicPlayer carrier, boolean proxyOriginated) {
        this(carrier, proxyOriginated, Singularity.getApiChannel());
    }

    public ProxiedMessage(CosmicPlayer carrier, boolean proxyOriginated, byte[] message) {
        this(carrier, proxyOriginated);
        this.writeAll(message);
    }

    public ProxiedMessage(CosmicPlayer carrier, boolean proxyOriginated, byte[] message, String mainChannel) {
        this(carrier, proxyOriginated, mainChannel);
        this.writeAll(message);
    }

    public boolean isBackendOriginated() {
        return !this.isProxyOriginated();
    }

    public void write(String key, String value) {
        if (key == null) {
            key = "";
        }
        if (value == null) {
            value = "";
        }
        this.getLiteralContents().put(key, value);
    }

    public void write(String utf) {
        SingleSet<String, String> r = this.extrapolate(utf);
        this.write(r.getKey(), r.getValue());
    }

    public void writeAll(byte[] bytes) {
        ByteArrayDataInput input = ByteStreams.newDataInput(bytes);
        boolean errored = false;
        while (!errored) {
            try {
                String utf = input.readUTF();
                this.write(utf);
            }
            catch (Exception e) {
                errored = true;
            }
        }
    }

    public SingleSet<String, String> extrapolate(String from) {
        List groups = MatcherUtils.getGroups((Matcher)MatcherUtils.matcherBuilder((String)"(.+)[=](.+)[;]", (String)from), (int)2);
        if (groups.isEmpty()) {
            return this.getArgumentSetFrom(from);
        }
        String[] strings = (String[])groups.get(0);
        return new SingleSet<String, String>(strings[0], strings[1]);
    }

    public SingleSet<String, String> getArgumentSetFrom(String from) {
        String key = this.getNextArgument();
        SingleSet<String, String> r = new SingleSet<String, String>(key, from);
        this.getArguments().put(this.getArguments().size(), r);
        return r;
    }

    public String getNextArgument() {
        return this.getArgumentKeyMaster().replace("%index%", String.valueOf(this.getArguments().size()));
    }

    public String getArgument(int index) {
        return this.getString(this.getArguments().get(index).getKey());
    }

    public boolean getBoolean(String key) {
        try {
            return Boolean.parseBoolean(this.getLiteralContents().get(key));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public long getLong(String key) {
        try {
            return Long.parseLong(this.getLiteralContents().get(key));
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public int getInteger(String key) {
        try {
            return Integer.parseInt(this.getLiteralContents().get(key));
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public double getDouble(String key) {
        try {
            return Double.parseDouble(this.getLiteralContents().get(key));
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public float getFloat(String key) {
        try {
            return Float.parseFloat(this.getLiteralContents().get(key));
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    public <T extends Enum<T>> T getEnum(String key, Class<T> en) {
        try {
            return Enum.valueOf(en, this.getLiteralContents().get(key));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ConcurrentSkipListSet<String> getJustifiedContents() {
        ConcurrentSkipListSet<String> r = new ConcurrentSkipListSet<String>();
        this.getLiteralContents().forEach((key, value) -> r.add(this.getJustifiedContent((String)key, (String)value)));
        return r;
    }

    public String getJustifiedContent(String key, String value) {
        return key + "=" + value + ";";
    }

    public String getString(String key) {
        return this.getLiteralContents().get(key);
    }

    public ConcurrentSkipListSet<String> getConcurrentStringList(String key, String separator) {
        return new ConcurrentSkipListSet<String>(this.getStringList(key, separator));
    }

    public ConcurrentSkipListSet<String> getConcurrentStringList(String key) {
        return this.getConcurrentStringList(key, this.getDefaultListSeparator());
    }

    public List<String> getStringList(String key, String separator) {
        String s2 = this.getString(key);
        if (s2 == null) {
            return new ArrayList<String>();
        }
        return Arrays.stream(s2.split(MatcherUtils.makeLiteral((String)separator))).collect(Collectors.toList());
    }

    public List<String> getStringList(String key) {
        return this.getStringList(key, this.getDefaultListSeparator());
    }

    public void write(String key, List<String> stringList, String separator) {
        StringBuilder builder = new StringBuilder();
        for (int i = 1; i <= stringList.size(); ++i) {
            String current = stringList.get(i - 1);
            if (i == stringList.size()) {
                builder.append(current);
                continue;
            }
            builder.append(current).append(separator);
        }
        this.write(key, builder.toString());
    }

    public void write(String key, List<String> stringList) {
        this.write(key, stringList, this.getDefaultListSeparator());
    }

    public void write(String key, ConcurrentSkipListSet<String> stringList, String separator) {
        this.write(key, new ArrayList<String>(stringList), separator);
    }

    public void write(String key, ConcurrentSkipListSet<String> stringList) {
        this.write(key, stringList, this.getDefaultListSeparator());
    }

    public byte[] read() {
        ByteArrayDataOutput output = ByteStreams.newDataOutput();
        for (String content : this.getJustifiedContents()) {
            output.writeUTF(content);
        }
        return output.toByteArray();
    }

    public boolean isReturnableLike() {
        return this.hasKey(ReturnableMessage.getKey());
    }

    public boolean hasKey(String key) {
        return this.getLiteralContents().containsKey(key);
    }

    public boolean hasValue(String value) {
        return this.getLiteralContents().containsValue(value);
    }

    public void send() {
        Singularity.getInstance().getProxyMessenger().sendMessage(this);
    }

    @Override
    public int compareTo(@NotNull ProxiedMessage o) {
        return Long.compare(this.getGottenAt().getTime(), o.getGottenAt().getTime());
    }

    public String getServerName() {
        return this.getCarrier().getServerName();
    }

    public CosmicServer getServer() {
        return this.getCarrier().getServer();
    }

    public String getDefaultListSeparator() {
        return this.defaultListSeparator;
    }

    public String getArgumentKeyMaster() {
        return this.argumentKeyMaster;
    }

    public String getSubChannelKey() {
        return this.subChannelKey;
    }

    public ConcurrentSkipListMap<Integer, SingleSet<String, String>> getArguments() {
        return this.arguments;
    }

    public ConcurrentSkipListMap<String, String> getLiteralContents() {
        return this.literalContents;
    }

    public CosmicPlayer getCarrier() {
        return this.carrier;
    }

    public boolean isProxyOriginated() {
        return this.proxyOriginated;
    }

    public String getMainChannel() {
        return this.mainChannel;
    }

    public Date getGottenAt() {
        return this.gottenAt;
    }

    public void setArguments(ConcurrentSkipListMap<Integer, SingleSet<String, String>> arguments) {
        this.arguments = arguments;
    }

    public void setLiteralContents(ConcurrentSkipListMap<String, String> literalContents) {
        this.literalContents = literalContents;
    }
}

