/*
 * Decompiled with CFR 0.152.
 */
package singularity.modules;

import gg.drak.thebase.objects.handling.derived.IModifierEventable;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.pf4j.PluginWrapper;
import singularity.Singularity;
import singularity.command.ModuleCommand;
import singularity.events.modules.ModuleDisableEvent;
import singularity.events.modules.ModuleEnableEvent;
import singularity.modules.ModuleLike;
import singularity.modules.ModuleManager;
import singularity.modules.ModuleUtils;
import singularity.utils.MessageUtils;

public abstract class CosmicModule
extends ModuleLike {
    private final File dataFolder;
    private boolean initialized;
    private boolean enabled;
    private boolean malleable = true;
    private ConcurrentSkipListSet<ModuleCommand> commands = new ConcurrentSkipListSet();

    public <C extends Collection<ModuleCommand>> void setCommands(C commands) {
        this.commands = new ConcurrentSkipListSet(commands);
    }

    public <C extends List<ModuleCommand>> void setCommands(C commands) {
        this.commands = new ConcurrentSkipListSet(commands);
    }

    @Override
    public String getIdentifier() {
        return this.wrapper.getDescriptor().getPluginId();
    }

    public ConcurrentSkipListSet<String> authors() {
        return new ConcurrentSkipListSet<String>(Arrays.stream(this.wrapper.getDescriptor().getProvider().replace(", ", ",").split(",")).collect(Collectors.toList()));
    }

    protected abstract void registerCommands();

    public CosmicModule(PluginWrapper wrapper) {
        super(wrapper);
        this.dataFolder = new File(Singularity.getModuleSaveFolder(), this.getIdentifier() + File.separator);
        ModuleManager.registerModule(this);
        this.onLoad();
    }

    @Override
    public void start() {
        if (this.isEnabled()) {
            return;
        }
        ModuleUtils.fireEvent(new ModuleEnableEvent(this));
        this.onEnable();
        this.setEnabled(true);
        ModuleManager.getEnabledModules().put(this.getIdentifier(), this);
        if (this.getCommands().isEmpty()) {
            this.registerCommands();
        }
        for (ModuleCommand command : this.getCommands()) {
            command.register();
        }
    }

    @Override
    public void stop() {
        if (!this.isEnabled()) {
            return;
        }
        for (ModuleCommand command : this.getCommands()) {
            try {
                ModuleUtils.logInfo((ModuleLike)this, "Unregistering command: " + command.getIdentifier());
                command.unregister();
            }
            catch (Throwable e) {
                ModuleUtils.logWarning((ModuleLike)this, "Failed to unregister command: " + command.getIdentifier());
                ModuleUtils.logWarning((ModuleLike)this, e.getStackTrace());
            }
        }
        ModuleUtils.fireEvent(new ModuleDisableEvent(this));
        this.onDisable();
        this.setEnabled(false);
        ModuleManager.getEnabledModules().remove(this.getIdentifier());
    }

    @Override
    public void restart() {
        this.stop();
        this.start();
    }

    public void unregister() {
        ModuleManager.unregisterModule(this);
    }

    public void register() {
        ModuleManager.registerModule(this);
    }

    public void onLoad() {
    }

    public abstract void onEnable();

    public abstract void onDisable();

    @Override
    public String getAuthorsStringed() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.authors().size(); ++i) {
            String author = this.authors().first();
            if (author == null) continue;
            builder.append(author);
            if (i >= this.authors().size() - 1) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    @Override
    public void logInfo(String message) {
        MessageUtils.logInfo((ModuleLike)this, message);
    }

    @Override
    public void logWarning(String message) {
        MessageUtils.logWarning((ModuleLike)this, message);
    }

    @Override
    public void logSevere(String message) {
        MessageUtils.logSevere((ModuleLike)this, message);
    }

    public void logDebug(StackTraceElement[] elements) {
        MessageUtils.logDebug((ModuleLike)this, elements);
    }

    public void logInfo(StackTraceElement[] elements) {
        MessageUtils.logInfo((ModuleLike)this, elements);
    }

    public void logWarning(StackTraceElement[] elements) {
        MessageUtils.logWarning((ModuleLike)this, elements);
    }

    public void logSevere(StackTraceElement[] elements) {
        MessageUtils.logSevere((ModuleLike)this, elements);
    }

    public void logDebug(String message) {
        MessageUtils.logDebug((ModuleLike)this, message);
    }

    @Override
    public InputStream getResourceAsStream(String filename) {
        return this.wrapper.getPluginClassLoader().getResourceAsStream(filename);
    }

    public boolean isRegisteredForSure() {
        return ModuleManager.getLoadedModules().containsValue(this);
    }

    public boolean isRegisteredByIdentifier() {
        return ModuleManager.getLoadedModules().containsKey(this.getIdentifier());
    }

    public IModifierEventable.ModifierType getModifierType() {
        return IModifierEventable.ModifierType.STREAMLINE;
    }

    public boolean isPlugin() {
        return false;
    }

    public boolean isMod() {
        return false;
    }

    public boolean isStreamline() {
        return true;
    }

    public void initializeDataFolder() {
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
    }

    public ModuleCommand getCommand(String identifier) {
        AtomicReference<Object> command = new AtomicReference<Object>(null);
        this.getCommands().forEach(moduleCommand -> {
            if (moduleCommand.getIdentifier().equalsIgnoreCase(identifier)) {
                command.set(moduleCommand);
            }
        });
        return command.get();
    }

    @Override
    public void addCommand(ModuleCommand command) {
        this.removeCommand(command.getIdentifier());
        this.getCommands().add(command);
    }

    public void removeCommand(String identifier) {
        this.getCommands().removeIf(moduleCommand -> moduleCommand.getIdentifier().equalsIgnoreCase(identifier));
    }

    @Override
    public void removeCommand(ModuleCommand command) {
        this.removeCommand(command.getIdentifier());
    }

    @Override
    public File getDataFolder() {
        return this.dataFolder;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isMalleable() {
        return this.malleable;
    }

    public ConcurrentSkipListSet<ModuleCommand> getCommands() {
        return this.commands;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void setMalleable(boolean malleable) {
        this.malleable = malleable;
    }
}

