/*
 * Decompiled with CFR 0.152.
 */
package singularity.placeholders;

import gg.drak.thebase.objects.AtomicString;
import gg.drak.thebase.utils.MatcherUtils;
import java.util.Objects;
import java.util.concurrent.ConcurrentSkipListMap;
import singularity.data.console.CosmicSender;
import singularity.modules.CosmicModule;
import singularity.modules.ModuleLike;
import singularity.placeholders.callbacks.RATCallback;
import singularity.placeholders.expansions.RATExpansion;
import singularity.placeholders.replaceables.AbstractReplaceable;
import singularity.placeholders.replaceables.GenericReplaceable;
import singularity.placeholders.replaceables.IdentifiedReplaceable;
import singularity.placeholders.replaceables.IdentifiedUserReplaceable;
import singularity.placeholders.replaceables.ModuleReplaceable;
import singularity.placeholders.replaceables.UserModuleReplaceable;
import singularity.placeholders.replaceables.UserReplaceable;
import singularity.utils.UserUtils;

public class RATRegistry {
    private static ConcurrentSkipListMap<String, AbstractReplaceable<? extends RATCallback>> replacements = new ConcurrentSkipListMap();

    public static void register(AbstractReplaceable<? extends RATCallback> replacement) {
        replacements.put(replacement.getHandledString().getRegex(), replacement);
    }

    public static void unregister(AbstractReplaceable<? extends RATCallback> replacement) {
        replacements.remove(replacement.getHandledString().getRegex());
    }

    public static void unregister(String from) {
        replacements.remove(from);
    }

    public static void unregisterAll() {
        replacements = new ConcurrentSkipListMap();
    }

    public static void unregisterAll(ModuleLike ModuleLike2) {
        replacements.values().removeIf(replacement -> replacement instanceof ModuleReplaceable && ((ModuleReplaceable)replacement).getModule().equals(ModuleLike2) || replacement instanceof UserModuleReplaceable && ((UserModuleReplaceable)replacement).getModule().equals(ModuleLike2));
    }

    public static void unregisterAll(String identifier) {
        replacements.values().removeIf(replacement -> replacement instanceof IdentifiedReplaceable && ((IdentifiedReplaceable)replacement).getIdentifier().equals(identifier) || replacement instanceof IdentifiedUserReplaceable && ((IdentifiedUserReplaceable)replacement).getIdentifier().equals(identifier));
    }

    public static void unregisterAllStartsWith(String startsWith) {
        RATRegistry.replacements.values().removeIf(replacements -> replacements.getHandledString().getRegex().startsWith(startsWith));
    }

    public static AbstractReplaceable<? extends RATCallback> getReplacement(String from) {
        return replacements.get(from);
    }

    public static String fetch(String from) {
        AtomicString result = new AtomicString(from);
        RATRegistry.getReplacements().forEach((s2, replacement) -> {
            if (replacement == null) {
                return;
            }
            if (!replacement.isReplaceWorthy()) {
                return;
            }
            if (replacement instanceof GenericReplaceable) {
                GenericReplaceable generic = (GenericReplaceable)replacement;
                result.set((Object)generic.fetch((String)result.get()));
            }
            if (replacement instanceof UserReplaceable) {
                UserReplaceable user = (UserReplaceable)replacement;
                result.set((Object)user.fetchAs((String)result.get(), UserUtils.getConsole()));
            }
        });
        return (String)result.get();
    }

    public static String fetchDirty(String from) {
        String temp = from;
        temp = RATRegistry.fetch(temp);
        while (!Objects.equals(temp, from)) {
            from = temp;
            temp = RATRegistry.fetch(temp);
        }
        return temp;
    }

    public static String fetch(String from, CosmicSender user) {
        AtomicString result = new AtomicString(from);
        RATRegistry.getReplacements().forEach((s2, replacement) -> {
            if (replacement instanceof UserReplaceable) {
                UserReplaceable userReplacement = (UserReplaceable)replacement;
                result.set((Object)userReplacement.fetchAs((String)result.get(), user));
            }
        });
        result.set((Object)RATRegistry.fetch((String)result.get()));
        return (String)result.get();
    }

    public static String fetchDirty(String from, CosmicSender user) {
        String temp = from;
        temp = RATRegistry.fetch(temp, user);
        while (!Objects.equals(temp, from)) {
            from = temp;
            temp = RATRegistry.fetch(temp, user);
        }
        return temp;
    }

    public static String getModuledDefault(String from, CosmicModule module) {
        return module.getIdentifier() + "_" + from;
    }

    public static String getRegexWithExpansion(String regex, RATExpansion expansion) {
        return MatcherUtils.makeLiteral((String)(expansion.getBuilder().getBoundingPrefix() + expansion.getBuilder().getIdentifier() + expansion.getBuilder().getSeparator())) + regex + MatcherUtils.makeLiteral((String)expansion.getBuilder().getBoundingSuffix());
    }

    public static String getLiteralWithExpansion(String literal, RATExpansion expansion) {
        return expansion.getBuilder().getBoundingPrefix() + expansion.getBuilder().getIdentifier() + expansion.getBuilder().getSeparator() + literal + expansion.getBuilder().getBoundingSuffix();
    }

    public static ConcurrentSkipListMap<String, AbstractReplaceable<? extends RATCallback>> getReplacements() {
        return replacements;
    }

    public static void setReplacements(ConcurrentSkipListMap<String, AbstractReplaceable<? extends RATCallback>> replacements) {
        RATRegistry.replacements = replacements;
    }
}

