/*
 * Decompiled with CFR 0.152.
 */
package singularity.placeholders.expansions;

import lombok.NonNull;
import org.jetbrains.annotations.NotNull;
import singularity.placeholders.RATRegistry;

public abstract class RATExpansion {
    @NonNull
    RATExpansionBuilder builder;

    public RATExpansion(@NonNull RATExpansionBuilder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.builder = builder;
        this.init();
    }

    public abstract void init();

    public void stop() {
        RATRegistry.unregisterAll(this.getBuilder().getIdentifier());
    }

    public void setBuilder(@NonNull RATExpansionBuilder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.builder = builder;
    }

    @NonNull
    public RATExpansionBuilder getBuilder() {
        return this.builder;
    }

    public static class RATExpansionBuilder {
        @NonNull
        private String identifier;
        @NonNull
        private String separator;
        @NonNull
        private String boundingPrefix;
        @NonNull
        private String boundingSuffix;

        public RATExpansionBuilder(@NonNull String identifier, @NonNull String separator, @NotNull String boundingPrefix, @NotNull String boundingSuffix) {
            if (identifier == null) {
                throw new NullPointerException("identifier is marked non-null but is null");
            }
            if (separator == null) {
                throw new NullPointerException("separator is marked non-null but is null");
            }
            this.identifier = identifier;
            this.separator = separator;
            this.boundingPrefix = boundingPrefix;
            this.boundingSuffix = boundingSuffix;
        }

        public RATExpansionBuilder(@NonNull String identifier, @NotNull String bounding) {
            this(identifier, "_", bounding, bounding);
            if (identifier == null) {
                throw new NullPointerException("identifier is marked non-null but is null");
            }
        }

        public RATExpansionBuilder(@NonNull String identifier) {
            this(identifier, "%");
            if (identifier == null) {
                throw new NullPointerException("identifier is marked non-null but is null");
            }
        }

        public void setIdentifier(@NonNull String identifier) {
            if (identifier == null) {
                throw new NullPointerException("identifier is marked non-null but is null");
            }
            this.identifier = identifier;
        }

        public void setSeparator(@NonNull String separator) {
            if (separator == null) {
                throw new NullPointerException("separator is marked non-null but is null");
            }
            this.separator = separator;
        }

        public void setBoundingPrefix(@NonNull String boundingPrefix) {
            if (boundingPrefix == null) {
                throw new NullPointerException("boundingPrefix is marked non-null but is null");
            }
            this.boundingPrefix = boundingPrefix;
        }

        public void setBoundingSuffix(@NonNull String boundingSuffix) {
            if (boundingSuffix == null) {
                throw new NullPointerException("boundingSuffix is marked non-null but is null");
            }
            this.boundingSuffix = boundingSuffix;
        }

        @NonNull
        public String getIdentifier() {
            return this.identifier;
        }

        @NonNull
        public String getSeparator() {
            return this.separator;
        }

        @NonNull
        public String getBoundingPrefix() {
            return this.boundingPrefix;
        }

        @NonNull
        public String getBoundingSuffix() {
            return this.boundingSuffix;
        }
    }
}

