/*
 * Decompiled with CFR 0.152.
 */
package de.leonhard.storage.internal.editor.toml;

import de.leonhard.storage.internal.editor.toml.TomlReader;
import de.leonhard.storage.internal.editor.toml.TomlWriter;
import de.leonhard.storage.internal.exceptions.TomlException;
import de.leonhard.storage.util.FastStringWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Map;
import lombok.Generated;

public final class TomlManager {
    public static final DateTimeFormatter DATE_FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral('T').append(DateTimeFormatter.ISO_LOCAL_TIME).optionalStart().appendOffsetId().optionalEnd().toFormatter();

    public static String writeToString(Map<String, Object> data) throws IOException {
        FastStringWriter writer = new FastStringWriter();
        TomlManager.write(data, writer);
        return writer.toString();
    }

    public static void write(Map<String, Object> data, File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        TomlManager.write(data, out);
    }

    public static void write(Map<String, Object> data, OutputStream out) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);
        TomlManager.write(data, writer);
    }

    public static void write(Map<String, Object> data, Writer writer) throws IOException {
        TomlWriter tw = new TomlWriter(writer);
        tw.write(data);
        tw.close();
    }

    public static void write(Map<String, Object> data, Writer writer, int indentSize, boolean indentWithSpaces) throws IOException {
        TomlWriter tw = new TomlWriter(writer, indentSize, indentWithSpaces);
        tw.write(data);
        tw.close();
    }

    public static Map<String, Object> read(String toml) throws TomlException {
        return TomlManager.read(toml, false);
    }

    public static Map<String, Object> read(String toml, boolean strictAsciiBareKeys) {
        TomlReader tr = new TomlReader(toml, strictAsciiBareKeys);
        return tr.read();
    }

    public static Map<String, Object> read(File file) throws IOException, TomlException {
        return TomlManager.read(file, false);
    }

    public static Map<String, Object> read(File file, boolean strictAsciiBareKeys) throws IOException, TomlException {
        return TomlManager.read(Files.newInputStream(file.toPath(), new OpenOption[0]), strictAsciiBareKeys);
    }

    public static Map<String, Object> read(InputStream in) throws IOException, TomlException {
        return TomlManager.read(in, false);
    }

    public static Map<String, Object> read(InputStream in, boolean strictAsciiBareKeys) throws IOException, TomlException {
        return TomlManager.read(new InputStreamReader(in, StandardCharsets.UTF_8), in.available(), strictAsciiBareKeys);
    }

    public static Map<String, Object> read(Reader reader, int bufferSize, boolean strictAsciiBareKeys) throws IOException, TomlException {
        int read;
        StringBuilder sb = new StringBuilder(bufferSize);
        char[] buf = new char[8192];
        while ((read = reader.read(buf)) != -1) {
            sb.append(buf, 0, read);
        }
        TomlReader tr = new TomlReader(sb.toString(), strictAsciiBareKeys);
        return tr.read();
    }

    @Generated
    private TomlManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

