/*
 * Decompiled with CFR 0.152.
 */
package gg.drak.thebase.lib.mysql.cj;

import gg.drak.thebase.lib.mysql.cj.CancelQueryTask;
import gg.drak.thebase.lib.mysql.cj.Messages;
import gg.drak.thebase.lib.mysql.cj.NativeSession;
import gg.drak.thebase.lib.mysql.cj.Query;
import gg.drak.thebase.lib.mysql.cj.TransactionEventHandler;
import gg.drak.thebase.lib.mysql.cj.conf.HostInfo;
import gg.drak.thebase.lib.mysql.cj.conf.PropertyKey;
import gg.drak.thebase.lib.mysql.cj.exceptions.OperationCancelledException;
import gg.drak.thebase.lib.mysql.cj.protocol.a.NativeMessageBuilder;
import java.util.TimerTask;

public class CancelQueryTaskImpl
extends TimerTask
implements CancelQueryTask {
    Query queryToCancel;
    Throwable caughtWhileCancelling = null;
    boolean queryTimeoutKillsConnection = false;

    public CancelQueryTaskImpl(Query cancellee) {
        this.queryToCancel = cancellee;
        NativeSession session = (NativeSession)cancellee.getSession();
        this.queryTimeoutKillsConnection = session.getPropertySet().getBooleanProperty(PropertyKey.queryTimeoutKillsConnection).getValue();
    }

    @Override
    public boolean cancel() {
        boolean res = super.cancel();
        this.queryToCancel = null;
        return res;
    }

    @Override
    public void run() {
        Thread cancelThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block18: {
                    Query localQueryToCancel = CancelQueryTaskImpl.this.queryToCancel;
                    if (localQueryToCancel == null) {
                        return;
                    }
                    NativeSession session = (NativeSession)localQueryToCancel.getSession();
                    if (session == null) {
                        return;
                    }
                    try {
                        if (CancelQueryTaskImpl.this.queryTimeoutKillsConnection) {
                            localQueryToCancel.setCancelStatus(Query.CancelStatus.CANCELED_BY_TIMEOUT);
                            session.invokeCleanupListeners(new OperationCancelledException(Messages.getString("Statement.ConnectionKilledDueToTimeout")));
                            break block18;
                        }
                        Object object = localQueryToCancel.getCancelTimeoutMutex();
                        synchronized (object) {
                            long origConnId = session.getThreadId();
                            HostInfo hostInfo = session.getHostInfo();
                            String database = hostInfo.getDatabase();
                            String user = hostInfo.getUser();
                            String password = hostInfo.getPassword();
                            NativeSession newSession = null;
                            try {
                                newSession = new NativeSession(hostInfo, session.getPropertySet());
                                newSession.connect(hostInfo, user, password, database, 30000, new TransactionEventHandler(){

                                    @Override
                                    public void transactionCompleted() {
                                    }

                                    @Override
                                    public void transactionBegun() {
                                    }
                                });
                                newSession.getProtocol().sendCommand(new NativeMessageBuilder(newSession.getServerSession().supportsQueryAttributes()).buildComQuery(newSession.getSharedSendPacket(), "KILL QUERY " + origConnId), false, 0);
                            }
                            finally {
                                try {
                                    newSession.forceClose();
                                }
                                catch (Throwable throwable) {}
                            }
                            localQueryToCancel.setCancelStatus(Query.CancelStatus.CANCELED_BY_TIMEOUT);
                        }
                    }
                    catch (Throwable t2) {
                        CancelQueryTaskImpl.this.caughtWhileCancelling = t2;
                    }
                    finally {
                        CancelQueryTaskImpl.this.setQueryToCancel(null);
                    }
                }
            }
        };
        cancelThread.start();
    }

    @Override
    public Throwable getCaughtWhileCancelling() {
        return this.caughtWhileCancelling;
    }

    @Override
    public void setCaughtWhileCancelling(Throwable caughtWhileCancelling) {
        this.caughtWhileCancelling = caughtWhileCancelling;
    }

    @Override
    public Query getQueryToCancel() {
        return this.queryToCancel;
    }

    @Override
    public void setQueryToCancel(Query queryToCancel) {
        this.queryToCancel = queryToCancel;
    }
}

