/*
 * Decompiled with CFR 0.152.
 */
package gg.drak.thebase.savables;

import gg.drak.thebase.events.BaseEventHandler;
import gg.drak.thebase.objects.Identifiable;
import gg.drak.thebase.savables.events.CreateSavableResourceEvent;
import gg.drak.thebase.savables.events.DeleteSavableResourceEvent;
import gg.drak.thebase.storage.resources.StorageResource;
import lombok.Generated;

public abstract class SavableResource
implements Identifiable {
    private StorageResource<?> storageResource;
    private String uuid;
    private boolean enabled;
    private boolean isFirstLoad = false;

    @Override
    public String getIdentifier() {
        return this.uuid;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.uuid = identifier;
    }

    public SavableResource(String uuid, StorageResource<?> storageResource) {
        this.uuid = uuid;
        this.storageResource = storageResource;
        try {
            this.enabled = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.enabled = false;
        }
        if (this.getStorageResource().isEmpty()) {
            this.setFirstLoad(true);
            CreateSavableResourceEvent<SavableResource> event = new CreateSavableResourceEvent<SavableResource>(this);
            BaseEventHandler.fireEvent(event);
            if (event.isCancelled()) {
                try {
                    this.dispose();
                    return;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        this.populateDefaults();
        this.loadValues();
    }

    public void reload() {
        this.storageResource.reloadResource();
    }

    public abstract void populateDefaults();

    public <T> T getOrSetDefault(String key, T def) {
        return this.storageResource.getOrSetDefault(key, def);
    }

    public abstract void loadValues();

    public abstract void saveAll();

    public void set(String key, Object value) {
        this.storageResource.write(key, value);
    }

    public String toString() {
        return "SavableResource()[ KEY: " + this.storageResource.getDiscriminatorKey() + " , VALUE: " + this.storageResource.getDiscriminator() + " ]";
    }

    public void dispose() throws Throwable {
        DeleteSavableResourceEvent<SavableResource> event = new DeleteSavableResourceEvent<SavableResource>(this);
        BaseEventHandler.fireEvent(event);
        if (event.isCancelled()) {
            return;
        }
        this.uuid = null;
        try {
            this.finalize();
        }
        catch (Throwable t2) {
            t2.printStackTrace();
        }
    }

    @Generated
    public StorageResource<?> getStorageResource() {
        return this.storageResource;
    }

    @Generated
    public void setStorageResource(StorageResource<?> storageResource) {
        this.storageResource = storageResource;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public boolean isFirstLoad() {
        return this.isFirstLoad;
    }

    @Generated
    public void setFirstLoad(boolean isFirstLoad) {
        this.isFirstLoad = isFirstLoad;
    }
}

