/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster.models.partitions;

import io.lettuce.core.RedisURI;
import io.lettuce.core.cluster.models.partitions.RedisClusterNode;
import io.lettuce.core.internal.LettuceAssert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Partitions
implements Collection<RedisClusterNode> {
    private static final RedisClusterNode[] EMPTY = new RedisClusterNode[16384];
    private final Lock lock = new ReentrantLock();
    private final List<RedisClusterNode> partitions = new ArrayList<RedisClusterNode>();
    private volatile RedisClusterNode[] slotCache = EMPTY;
    private volatile RedisClusterNode[] masterCache = EMPTY;
    private volatile Collection<RedisClusterNode> nodeReadView = Collections.emptyList();

    public Partitions clone() {
        ArrayList<RedisClusterNode> readView = new ArrayList<RedisClusterNode>(this.nodeReadView);
        Partitions copy = new Partitions();
        for (RedisClusterNode node : readView) {
            copy.addPartition(node.clone());
        }
        copy.updateCache();
        return copy;
    }

    public RedisClusterNode getPartitionBySlot(int slot) {
        return this.slotCache[slot];
    }

    public RedisClusterNode getMasterBySlot(int slot) {
        return this.masterCache[slot];
    }

    public RedisClusterNode getPartitionByNodeId(String nodeId) {
        for (RedisClusterNode partition : this.nodeReadView) {
            if (!partition.getNodeId().equals(nodeId)) continue;
            return partition;
        }
        return null;
    }

    public RedisClusterNode getPartition(String host, int port) {
        for (RedisClusterNode partition : this.nodeReadView) {
            RedisURI uri = partition.getUri();
            if (Partitions.matches(uri, host, port)) {
                return partition;
            }
            for (RedisURI redisURI : partition.getAliases()) {
                if (!Partitions.matches(redisURI, host, port)) continue;
                return partition;
            }
        }
        return null;
    }

    private static boolean matches(RedisURI uri, String host, int port) {
        return uri.getPort() == port && host.equals(uri.getHost());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCache() {
        this.lock.lock();
        try {
            if (this.partitions.isEmpty()) {
                this.invalidateCache();
                return;
            }
            RedisClusterNode[] slotCache = new RedisClusterNode[16384];
            RedisClusterNode[] masterCache = new RedisClusterNode[16384];
            ArrayList<RedisClusterNode> readView = new ArrayList<RedisClusterNode>(this.partitions.size());
            for (RedisClusterNode partition : this.partitions) {
                readView.add(partition);
                if (partition.is(RedisClusterNode.NodeFlag.UPSTREAM)) {
                    partition.forEachSlot(i2 -> {
                        masterCache[i2] = partition;
                    });
                }
                partition.forEachSlot(i2 -> {
                    slotCache[i2] = partition;
                });
            }
            this.slotCache = slotCache;
            this.masterCache = masterCache;
            this.nodeReadView = Collections.unmodifiableCollection(readView);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void invalidateCache() {
        this.slotCache = EMPTY;
        this.masterCache = EMPTY;
        this.nodeReadView = Collections.emptyList();
    }

    @Override
    public Iterator<RedisClusterNode> iterator() {
        return this.nodeReadView.iterator();
    }

    public List<RedisClusterNode> getPartitions() {
        return this.partitions;
    }

    public void addPartition(RedisClusterNode partition) {
        LettuceAssert.notNull((Object)partition, "Partition must not be null");
        this.lock.lock();
        try {
            this.invalidateCache();
            this.partitions.add(partition);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int size() {
        return this.nodeReadView.size();
    }

    public RedisClusterNode getPartition(int index) {
        return this.partitions.get(index);
    }

    public void reload(List<RedisClusterNode> partitions) {
        LettuceAssert.noNullElements(partitions, "Partitions must not contain null elements");
        this.lock.lock();
        try {
            this.partitions.clear();
            this.partitions.addAll(partitions);
            this.updateCache();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.nodeReadView.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.nodeReadView.contains(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends RedisClusterNode> c) {
        LettuceAssert.noNullElements(c, "Partitions must not contain null elements");
        this.lock.lock();
        try {
            boolean b = this.partitions.addAll(c);
            this.updateCache();
            boolean bl = b;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        this.lock.lock();
        try {
            boolean b = this.getPartitions().removeAll(c);
            this.updateCache();
            boolean bl = b;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        this.lock.lock();
        try {
            boolean b = this.getPartitions().retainAll(c);
            this.updateCache();
            boolean bl = b;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.getPartitions().clear();
            this.updateCache();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Object[] toArray() {
        return this.nodeReadView.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.nodeReadView.toArray(a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(RedisClusterNode redisClusterNode) {
        this.lock.lock();
        try {
            LettuceAssert.notNull((Object)redisClusterNode, "RedisClusterNode must not be null");
            boolean add = this.getPartitions().add(redisClusterNode);
            this.updateCache();
            boolean bl = add;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        this.lock.lock();
        try {
            boolean remove2 = this.getPartitions().remove(o);
            this.updateCache();
            boolean bl = remove2;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.nodeReadView.containsAll(c);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" ").append(this.partitions);
        return sb.toString();
    }
}

