/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.search;

import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.output.ComplexData;
import io.lettuce.core.output.ComplexDataParser;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SynonymMapParser<K, V>
implements ComplexDataParser<Map<V, List<V>>> {
    private final RedisCodec<K, V> codec;

    public SynonymMapParser(RedisCodec<K, V> codec) {
        this.codec = codec;
    }

    @Override
    public Map<V, List<V>> parse(ComplexData data) {
        if (data == null) {
            return new LinkedHashMap();
        }
        if (data.isList()) {
            return this.parseResp2(data);
        }
        return this.parseResp3(data);
    }

    private Map<V, List<V>> parseResp2(ComplexData data) {
        List<Object> synonymArray = data.getDynamicList();
        LinkedHashMap synonymMap = new LinkedHashMap();
        int i2 = 0;
        while (i2 < synonymArray.size() && i2 + 2 <= synonymArray.size()) {
            V term = this.codec.decodeValue((ByteBuffer)synonymArray.get(i2++));
            ComplexData synonymsData = (ComplexData)synonymArray.get(i2++);
            List<Object> synonims = synonymsData.getDynamicList();
            List decodedSynonyms = synonims.stream().map(synonym -> this.codec.decodeValue((ByteBuffer)synonym)).collect(Collectors.toList());
            synonymMap.put(term, decodedSynonyms);
        }
        return synonymMap;
    }

    private Map<V, List<V>> parseResp3(ComplexData data) {
        Map<Object, Object> synonymMapRaw = data.getDynamicMap();
        LinkedHashMap synonymMap = new LinkedHashMap();
        for (Map.Entry<Object, Object> entry : synonymMapRaw.entrySet()) {
            V term = this.codec.decodeValue((ByteBuffer)entry.getKey());
            Object synonymsData = entry.getValue();
            List<Object> synonymsList = ((ComplexData)synonymsData).getDynamicList();
            List synonyms = synonymsList.stream().map(synonym -> this.codec.decodeValue((ByteBuffer)synonym)).collect(Collectors.toList());
            synonymMap.put(term, synonyms);
        }
        return synonymMap;
    }
}

