/*
 * Decompiled with CFR 0.152.
 */
package net.streamline.api.holders;

import java.util.UUID;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import singularity.holders.CosmicDependencyHolder;
import singularity.holders.builtin.CosmicGeyserHolder;
import singularity.utils.UuidUtils;

public class GeyserHolder
extends CosmicDependencyHolder<FloodgateApi>
implements CosmicGeyserHolder {
    public GeyserHolder() {
        super("geyser", "floodgate", "floodgate-spigot", "floodgate-bungee", "floodgate-velocity");
        this.tryLoad(this::tryLoadThis);
    }

    public Void tryLoadThis() {
        FloodgateApi api = FloodgateApi.getInstance();
        if (api != null) {
            this.setApi(api);
            return null;
        }
        return null;
    }

    @Override
    public boolean isBedrockUUID(String uuid) {
        if (this.getApi() == null) {
            return false;
        }
        if (!UuidUtils.isUuid(uuid)) {
            return true;
        }
        UUID u = UUID.fromString(uuid);
        FloodgatePlayer player = ((FloodgateApi)this.getApi()).getPlayer(u);
        return player != null && player.getCorrectUsername() != null;
    }

    @Override
    public boolean isBedrockName(String name) {
        if (this.getApi() == null) {
            return false;
        }
        UUID uuid = (UUID)((FloodgateApi)this.getApi()).getUuidFor(name).join();
        return uuid != null;
    }

    @Override
    public String getBedrockPrefix() {
        if (this.getApi() == null) {
            return null;
        }
        return ((FloodgateApi)this.getApi()).getPlayerPrefix();
    }

    @Override
    public String getUsernameFromBedrockUUID(String uuid) {
        if (this.getApi() == null) {
            return "";
        }
        if (!UuidUtils.isUuid(uuid)) {
            return "";
        }
        UUID u = UUID.fromString(uuid);
        FloodgatePlayer player = ((FloodgateApi)this.getApi()).getPlayer(u);
        if (player != null && player.getCorrectUsername() != null) {
            return player.getCorrectUsername();
        }
        return null;
    }

    @Override
    public String getBedrockUUIDFromUsername(String name) {
        if (this.getApi() == null) {
            return "";
        }
        UUID uuid = (UUID)((FloodgateApi)this.getApi()).getUuidFor(name).join();
        if (uuid != null) {
            return uuid.toString();
        }
        return null;
    }
}

