/*
 * Decompiled with CFR 0.152.
 */
package net.streamline.platform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.chat.ComponentSerializer;
import net.streamline.api.SLAPI;
import net.streamline.base.StreamlineBungee;
import net.streamline.platform.savables.UserManager;
import org.jetbrains.annotations.Nullable;
import singularity.data.console.CosmicSender;
import singularity.data.players.CosmicPlayer;
import singularity.interfaces.IMessenger;
import singularity.modules.ModuleUtils;
import singularity.objects.CosmicTitle;
import singularity.text.HexPolicy;
import singularity.text.TextManager;
import singularity.utils.MessageUtils;

public class Messenger
implements IMessenger {
    private static Messenger instance;

    public Messenger() {
        instance = this;
    }

    public void sendMessage(@Nullable CommandSender to, String message) {
        if (to == null) {
            return;
        }
        if (!SLAPI.isReady()) {
            to.sendMessage(this.codedText(message));
        } else {
            to.sendMessage(this.codedText(this.replaceAllPlayerBungee(to, message)));
        }
    }

    public void sendMessage(@Nullable CommandSender to, String otherUUID, String message) {
        if (to == null) {
            return;
        }
        if (!SLAPI.isReady()) {
            to.sendMessage(this.codedText(message));
        } else {
            to.sendMessage(this.codedText(MessageUtils.replaceAllPlayerBungee(otherUUID, message)));
        }
    }

    public void sendMessage(@Nullable CommandSender to, CosmicSender other, String message) {
        if (to == null) {
            return;
        }
        if (!SLAPI.isReady()) {
            to.sendMessage(this.codedText(message));
        } else {
            to.sendMessage(this.codedText(MessageUtils.replaceAllPlayerBungee(other, message)));
        }
    }

    @Override
    public void sendMessage(@Nullable CosmicSender to, String message) {
        if (to == null) {
            return;
        }
        if (to instanceof CosmicPlayer) {
            this.sendMessage((CommandSender)StreamlineBungee.getPlayer(to.getUuid()), message);
        } else {
            this.sendMessage(ProxyServer.getInstance().getConsole(), message);
        }
    }

    @Override
    public void sendMessage(@Nullable CosmicSender to, String otherUUID, String message) {
        if (to == null) {
            return;
        }
        if (to instanceof CosmicPlayer) {
            this.sendMessage((CommandSender)StreamlineBungee.getPlayer(to.getUuid()), otherUUID, message);
        } else {
            this.sendMessage(ProxyServer.getInstance().getConsole(), otherUUID, message);
        }
    }

    @Override
    public void sendMessage(@Nullable CosmicSender to, CosmicSender other, String message) {
        if (to == null || other == null) {
            return;
        }
        if (to instanceof CosmicPlayer) {
            this.sendMessage((CommandSender)StreamlineBungee.getPlayer(to.getUuid()), other, message);
        } else {
            this.sendMessage(ProxyServer.getInstance().getConsole(), other, message);
        }
    }

    public void sendMessageRaw(CommandSender to, String message) {
        if (to == null) {
            return;
        }
        BaseComponent[] component = !SLAPI.isReady() ? new ComponentBuilder(message).create() : new ComponentBuilder(this.replaceAllPlayerBungee(to, message)).create();
        to.sendMessage(component);
    }

    public void sendMessageRaw(CommandSender to, String otherUUID, String message) {
        if (to == null) {
            return;
        }
        BaseComponent[] component = !SLAPI.isReady() ? new ComponentBuilder(message).create() : new ComponentBuilder(MessageUtils.replaceAllPlayerBungee(otherUUID, message)).create();
        to.sendMessage(component);
    }

    public void sendMessageRaw(CommandSender to, CosmicSender other, String message) {
        if (to == null) {
            return;
        }
        BaseComponent[] component = !SLAPI.isReady() ? new ComponentBuilder(message).create() : new ComponentBuilder(MessageUtils.replaceAllPlayerBungee(other, message)).create();
        to.sendMessage(component);
    }

    @Override
    public void sendMessageRaw(@Nullable CosmicSender to, String message) {
        if (to == null) {
            return;
        }
        if (to instanceof CosmicPlayer) {
            this.sendMessageRaw((CommandSender)StreamlineBungee.getPlayer(to.getUuid()), message);
        } else {
            this.sendMessageRaw(ProxyServer.getInstance().getConsole(), message);
        }
    }

    @Override
    public void sendMessageRaw(@Nullable CosmicSender to, String otherUUID, String message) {
        if (to == null) {
            return;
        }
        if (to instanceof CosmicPlayer) {
            this.sendMessageRaw((CommandSender)StreamlineBungee.getPlayer(to.getUuid()), otherUUID, message);
        } else {
            this.sendMessageRaw(ProxyServer.getInstance().getConsole(), otherUUID, message);
        }
    }

    @Override
    public void sendMessageRaw(@Nullable CosmicSender to, CosmicSender other, String message) {
        if (to == null || other == null) {
            return;
        }
        if (to instanceof CosmicPlayer) {
            this.sendMessageRaw((CommandSender)StreamlineBungee.getPlayer(to.getUuid()), other, message);
        } else {
            this.sendMessageRaw(ProxyServer.getInstance().getConsole(), other, message);
        }
    }

    @Override
    public void sendTitle(CosmicSender player, CosmicTitle title) {
        ProxiedPlayer p = StreamlineBungee.getPlayer(player.getUuid());
        if (p == null) {
            MessageUtils.logInfo("Could not send a title to a player because player is null!");
            return;
        }
        p.sendTitle(StreamlineBungee.getInstance().getProxy().createTitle().title(this.codedText(title.getMain())).subTitle(this.codedText(title.getSub())).fadeIn((int)title.getFadeIn()).stay((int)title.getStay()).fadeOut((int)title.getFadeOut()));
    }

    @Override
    public String codedString(String from) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)ModuleUtils.newLined(from));
    }

    @Override
    public String stripColor(String string) {
        return ChatColor.stripColor((String)string).replaceAll("([<][#][1-9a-f][1-9a-f][1-9a-f][1-9a-f][1-9a-f][1-9a-f][>])+", "");
    }

    public BaseComponent[] codedText(String from) {
        String raw = from;
        ArrayList componentsList = new ArrayList();
        for (HexPolicy policy : TextManager.getHexPolicies()) {
            Iterator<String> iterator = TextManager.extractHexCodes(raw, policy).iterator();
            while (iterator.hasNext()) {
                Object hexCode;
                Object original = hexCode = iterator.next();
                if (!((String)hexCode).startsWith("#")) {
                    hexCode = "#" + (String)hexCode;
                }
                String replacement = ChatColor.of((String)hexCode).toString();
                raw = raw.replace(policy.getResult((String)original), replacement);
            }
        }
        raw = this.codedString(raw);
        String legacy = MessageUtils.codedString(raw);
        List<String> jsonStrings = TextManager.extractJsonStrings(legacy, "!!json:");
        int lastEnd = 0;
        for (String jsonStr : jsonStrings) {
            int index = legacy.indexOf("!!json:" + jsonStr);
            String before = legacy.substring(lastEnd, index);
            BaseComponent[] beforeComponent = TextComponent.fromLegacyText((String)before);
            Collections.addAll(componentsList, beforeComponent);
            try {
                BaseComponent[] jsonComponent = ComponentSerializer.parse((String)jsonStr);
                Collections.addAll(componentsList, jsonComponent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            lastEnd = index + jsonStr.length() + 7;
        }
        if (lastEnd < legacy.length()) {
            BaseComponent[] remainingComponent = TextComponent.fromLegacyText((String)legacy.substring(lastEnd));
            Collections.addAll(componentsList, remainingComponent);
        }
        return componentsList.toArray(new BaseComponent[0]);
    }

    public String replaceAllPlayerBungee(CommandSender sender, String of) {
        CosmicSender s2 = UserManager.getInstance().getOrCreateSender(sender).orElse(null);
        if (s2 == null) {
            return of;
        }
        return MessageUtils.replaceAllPlayerBungee(s2, of);
    }

    public static Messenger getInstance() {
        return instance;
    }
}

