/*
 * Decompiled with CFR 0.152.
 */
package net.streamline.platform.commands;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentSkipListSet;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.TabExecutor;
import net.streamline.base.StreamlineBungee;
import net.streamline.platform.Messenger;
import net.streamline.platform.savables.UserManager;
import org.jetbrains.annotations.NotNull;
import singularity.command.CosmicCommand;
import singularity.data.console.CosmicSender;
import singularity.interfaces.IProperCommand;
import singularity.utils.MessageUtils;

public class ProperCommand
extends Command
implements TabExecutor,
IProperCommand {
    private final CosmicCommand parent;

    public ProperCommand(CosmicCommand parent) {
        super(parent.getBase(), parent.getPermission(), parent.getAliases());
        this.parent = parent;
    }

    public void execute(@NotNull CommandSender sender, @NotNull String[] args) {
        try {
            CosmicSender s2 = UserManager.getInstance().getOrCreateSender(sender).orElse(null);
            if (s2 == null) {
                MessageUtils.logWarning("Command execution failed: Sender is not a CosmicSender.");
                return;
            }
            this.parent.baseRun(s2, args);
        }
        catch (Throwable e) {
            Messenger.getInstance().sendMessage(sender, "&cAn error occurred while executing the command &7'&e" + this.getName() + "&7'&8. &cPlease tell an admin to check the console.");
            MessageUtils.logWarning("An error occurred while executing command '" + this.parent.getBase() + "': " + e.getMessage());
            e.printStackTrace();
        }
    }

    public Iterable<String> onTabComplete(CommandSender sender, String[] args) {
        try {
            CosmicSender s2;
            if (args == null) {
                args = new String[]{""};
            }
            if (args.length < 1) {
                args = new String[]{""};
            }
            if ((s2 = (CosmicSender)UserManager.getInstance().getOrCreateSender(sender).orElse(null)) == null) {
                MessageUtils.logWarning("Tab completion failed: Sender is not a CosmicSender.");
                return new ArrayList<String>();
            }
            ConcurrentSkipListSet<String> r = this.parent.baseTabComplete(s2, args);
            return r == null ? new ArrayList<String>() : MessageUtils.getCompletion(r, args[args.length - 1]);
        }
        catch (Throwable e) {
            MessageUtils.logWarning("An error occurred while tab completing command '" + this.parent.getBase() + "': " + e.getMessage());
            e.printStackTrace();
            return new ArrayList<String>();
        }
    }

    @Override
    public void register() {
        StreamlineBungee.getInstance().getProxy().getPluginManager().registerCommand((Plugin)StreamlineBungee.getInstance(), (Command)this);
    }

    @Override
    public void unregister() {
        StreamlineBungee.getInstance().getProxy().getPluginManager().unregisterCommand((Command)this);
    }

    public CosmicCommand getParent() {
        return this.parent;
    }
}

