/*
 * Decompiled with CFR 0.152.
 */
package singularity.data.players.location;

public class PlayerRotation {
    private float yaw;
    private float pitch;

    public PlayerRotation(float yaw, float pitch) {
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public PlayerRotation() {
        this(0.0f, 0.0f);
    }

    public PlayerRotation addYaw(float yaw) {
        this.yaw += yaw;
        return this;
    }

    public PlayerRotation addPitch(float pitch) {
        this.pitch += pitch;
        return this;
    }

    public PlayerRotation removeYaw(float yaw) {
        this.yaw -= yaw;
        return this;
    }

    public PlayerRotation removePitch(float pitch) {
        this.pitch -= pitch;
        return this;
    }

    public PlayerRotation setYaw(float yaw) {
        this.yaw = yaw;
        return this;
    }

    public PlayerRotation setPitch(float pitch) {
        this.pitch = pitch;
        return this;
    }

    public float get(RotationType type) {
        return type == RotationType.YAW ? this.yaw : this.pitch;
    }

    public PlayerRotation set(RotationType type, float value) {
        if (type == RotationType.YAW) {
            this.setYaw(value);
        } else {
            this.setPitch(value);
        }
        return this;
    }

    public PlayerRotation add(RotationType type, float value) {
        if (type == RotationType.YAW) {
            this.addYaw(value);
        } else {
            this.addPitch(value);
        }
        return this;
    }

    public PlayerRotation remove(RotationType type, float value) {
        if (type == RotationType.YAW) {
            this.removeYaw(value);
        } else {
            this.removePitch(value);
        }
        return this;
    }

    public String toString() {
        return this.getYaw() + ";" + this.getPitch();
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public static enum RotationType {
        YAW,
        PITCH;

    }
}

