/*
 * Decompiled with CFR 0.152.
 */
package singularity.data.players.location;

import org.jetbrains.annotations.NotNull;
import singularity.data.players.location.BlockPosition;

public class WorldPosition
implements Comparable<WorldPosition> {
    private double x;
    private double y;
    private double z;

    public WorldPosition(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public int compareTo(@NotNull WorldPosition o) {
        if (this.x != o.x) {
            return Double.compare(this.x, o.x);
        }
        if (this.y != o.y) {
            return Double.compare(this.y, o.y);
        }
        return Double.compare(this.z, o.z);
    }

    public WorldPosition copy() {
        return new WorldPosition(this.x, this.y, this.z);
    }

    public double distance(WorldPosition other) {
        return Math.sqrt(Math.pow(this.x - other.x, 2.0) + Math.pow(this.y - other.y, 2.0) + Math.pow(this.z - other.z, 2.0));
    }

    public BlockPosition asBlockPosition() {
        int x = (int)Math.round(this.x);
        int y = (int)Math.round(this.y);
        int z = (int)Math.round(this.z);
        return new BlockPosition(x, y, z);
    }

    public String toString() {
        return this.getX() + ";" + this.getY() + ";" + this.getZ();
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }
}

