/*
 * Decompiled with CFR 0.152.
 */
package singularity.data.runners;

import singularity.configs.given.GivenConfigs;
import singularity.data.update.defaults.CosmicPlayerUpdater;
import singularity.data.update.defaults.DefaultUpdaters;
import singularity.scheduler.BaseRunnable;
import singularity.utils.UserUtils;

public class PlayerSaver
extends BaseRunnable {
    public PlayerSaver() {
        super(0L, GivenConfigs.getMainConfig().getPlayerDataSaveInterval());
    }

    @Override
    public void run() {
        long p = this.getPeriod();
        if (p != GivenConfigs.getMainConfig().getPlayerDataSaveInterval()) {
            this.setPeriod(GivenConfigs.getMainConfig().getPlayerDataSaveInterval());
        }
        CosmicPlayerUpdater updater = DefaultUpdaters.getPlayerUpdater();
        UserUtils.getLoadedPlayers().forEach((string, cosmicPlayer) -> {
            boolean updated = updater.checkAndPut(cosmicPlayer.getIdentifier());
            if (updated) {
                return;
            }
            cosmicPlayer.save();
            if (!cosmicPlayer.isOnline()) {
                UserUtils.unloadSender(cosmicPlayer);
            }
        });
    }
}

