/*
 * Decompiled with CFR 0.152.
 */
package singularity.database;

import gg.drak.thebase.lib.hikari.HikariConfig;
import gg.drak.thebase.lib.hikari.HikariDataSource;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import singularity.Singularity;
import singularity.database.ConnectorSet;
import singularity.database.DBAction;
import singularity.database.DatabaseType;
import singularity.database.ExecutionResult;
import singularity.utils.MessageUtils;

public abstract class DBOperator {
    private ConnectorSet connectorSet;
    private HikariDataSource dataSource;
    private String pluginUser;
    private Connection rawConnection;

    public DBOperator(ConnectorSet connectorSet, String pluginUser) {
        this.connectorSet = connectorSet;
        this.pluginUser = pluginUser;
        this.dataSource = this.buildDataSource();
    }

    public HikariDataSource buildDataSource() {
        HikariConfig config = new HikariConfig();
        switch (this.connectorSet.getType()) {
            case MYSQL: {
                config.setJdbcUrl(this.connectorSet.getUri());
                config.setUsername(this.connectorSet.getUsername());
                config.setPassword(this.connectorSet.getPassword());
                break;
            }
            case SQLITE: {
                this.initializeSQLiteDatabase();
                config.setJdbcUrl(this.connectorSet.getUri() + DBOperator.getDatabaseFolder().getPath() + File.separator + this.connectorSet.getSqliteFileName());
            }
        }
        config.setPoolName(this.pluginUser + " - Pool");
        config.setMaximumPoolSize(10);
        config.setMinimumIdle(2);
        config.setConnectionTimeout(30000L);
        config.setIdleTimeout(600000L);
        config.setMaxLifetime(1800000L);
        config.setDriverClassName(this.connectorSet.getType().getDriver());
        config.setConnectionTestQuery("SELECT 1");
        return new HikariDataSource(config);
    }

    public Connection getConnection() {
        try {
            if (this.dataSource == null) {
                this.dataSource = this.buildDataSource();
            }
            return this.dataSource.getConnection();
        }
        catch (Exception e) {
            MessageUtils.logWarning("Failed to get connection", e);
            return null;
        }
    }

    public DatabaseType getType() {
        return this.connectorSet.getType();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ExecutionResult executeSingle(String statement, Consumer<PreparedStatement> statementBuilder) {
        try (Connection connection = this.getConnection();){
            ExecutionResult executionResult;
            block14: {
                PreparedStatement stmt = connection.prepareStatement(statement);
                try {
                    statementBuilder.accept(stmt);
                    ExecutionResult executionResult2 = executionResult = stmt.execute() ? ExecutionResult.YES : ExecutionResult.NO;
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return executionResult;
        }
        catch (Exception e) {
            MessageUtils.logWarning("Failed to execute statement: " + statement, e);
            return ExecutionResult.ERROR;
        }
    }

    public void executeQuery(String statement, Consumer<PreparedStatement> statementBuilder, DBAction action) {
        try (Connection connection = this.getConnection();
             PreparedStatement stmt = connection.prepareStatement(statement);){
            statementBuilder.accept(stmt);
            try (ResultSet set2 = stmt.executeQuery();){
                action.accept(set2);
            }
        }
        catch (Exception e) {
            MessageUtils.logWarning("Failed to execute query: " + statement, e);
        }
    }

    public List<ExecutionResult> execute(String statement, Consumer<PreparedStatement> statementBuilder) {
        String[] statements;
        ArrayList<ExecutionResult> results = new ArrayList<ExecutionResult>();
        for (String s2 : statements = statement.split(";;")) {
            if (s2 == null || s2.isEmpty() || s2.isBlank()) continue;
            Object fs = s2;
            if (!((String)fs).endsWith(";")) {
                fs = (String)fs + ";";
            }
            results.add(this.executeSingle((String)fs, statementBuilder));
        }
        return results;
    }

    public void ensureFile() {
        if (this.getConnectorSet().getType() != DatabaseType.SQLITE) {
            return;
        }
        String s1 = this.getConnectorSet().getSqliteFileName();
        if (s1 == null) {
            return;
        }
        if (s1.isBlank()) {
            return;
        }
        this.initializeSQLiteDatabase();
    }

    public abstract void ensureTables();

    public abstract void ensureDatabase();

    public void ensureUsable() {
        this.ensureFile();
        this.ensureDatabase();
        this.ensureTables();
    }

    public static File getDatabaseFolder() {
        File folder = new File(Singularity.getInstance().getDataFolder(), "storage");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        return folder;
    }

    private void initializeSQLiteDatabase() {
        File file;
        if (this.connectorSet.getType() == DatabaseType.SQLITE && !(file = new File(DBOperator.getDatabaseFolder(), this.connectorSet.getSqliteFileName())).exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                MessageUtils.logWarning("Failed to create SQLite database file", e);
            }
        }
    }

    public ConnectorSet getConnectorSet() {
        return this.connectorSet;
    }

    public HikariDataSource getDataSource() {
        return this.dataSource;
    }

    public String getPluginUser() {
        return this.pluginUser;
    }

    public Connection getRawConnection() {
        return this.rawConnection;
    }

    public void setConnectorSet(ConnectorSet connectorSet) {
        this.connectorSet = connectorSet;
    }

    public void setDataSource(HikariDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setPluginUser(String pluginUser) {
        this.pluginUser = pluginUser;
    }

    public void setRawConnection(Connection rawConnection) {
        this.rawConnection = rawConnection;
    }
}

