/*
 * Decompiled with CFR 0.152.
 */
package singularity.interfaces;

import java.util.concurrent.ConcurrentSkipListSet;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import singularity.command.CosmicCommand;
import singularity.data.players.CosmicPlayer;
import singularity.data.players.location.PlayerRotation;
import singularity.data.players.location.PlayerWorld;
import singularity.data.players.location.WorldPosition;
import singularity.events.CosmicEvent;
import singularity.interfaces.IProperCommand;
import singularity.interfaces.IProperEvent;
import singularity.objects.CosmicResourcePack;

public interface ISingularityExtension {
    public PlatformType getPlatformType();

    public ServerType getServerType();

    public void fireEvent(IProperEvent<?> var1);

    public void fireEvent(CosmicEvent var1);

    public void fireEvent(CosmicEvent var1, boolean var2);

    public void handleMisSync(CosmicEvent var1, boolean var2);

    @NotNull
    public ConcurrentSkipListSet<CosmicPlayer> getOnlinePlayers();

    public ConcurrentSkipListSet<String> getOnlinePlayerNames();

    public ConcurrentSkipListSet<String> getServerNames();

    public boolean serverHasPlugin(String var1);

    public boolean equalsAnyServer(String var1);

    public IProperCommand createCommand(CosmicCommand var1);

    public int getMaxPlayers();

    public long getConnectionThrottle();

    public boolean getOnlineMode();

    public void shutdown();

    public int broadcast(@NotNull String var1, @NotNull String var2);

    public String getVersion();

    public void sendResourcePack(CosmicResourcePack var1, CosmicPlayer var2);

    public void sendResourcePack(CosmicResourcePack var1, String var2);

    public ClassLoader getMainClassLoader();

    public String getName();

    public boolean isOfflineMode();

    public java.util.logging.Logger getLoggerLogger();

    default public boolean hasLoggerLogger() {
        return this.getLoggerLogger() != null;
    }

    public Logger getSLFLogger();

    default public boolean hasSLFLogger() {
        return this.getSLFLogger() != null;
    }

    default public void teleportBackend(CosmicPlayer player, PlayerWorld world, WorldPosition position, PlayerRotation rotation) {
    }

    public static enum ServerType {
        PROXY,
        BACKEND;

    }

    public static enum PlatformType {
        BUNGEE,
        SPIGOT,
        VELOCITY;

    }
}

