/*
 * Decompiled with CFR 0.152.
 */
package singularity.messages.builders;

import org.apache.commons.codec.binary.Hex;
import singularity.data.players.CosmicPlayer;
import singularity.messages.proxied.ProxiedMessage;
import singularity.objects.CosmicResourcePack;
import singularity.objects.SingleSet;
import singularity.utils.MessageUtils;

public class ResourcePackMessageBuilder {
    private static final String subChannel = "resource-pack";

    public static ProxiedMessage build(CosmicPlayer carrier, boolean isProxyOriginated, CosmicPlayer user, CosmicResourcePack resourcePack) {
        ProxiedMessage r = new ProxiedMessage(carrier, isProxyOriginated);
        r.setSubChannel(ResourcePackMessageBuilder.getSubChannel());
        r.write("user_uuid", user.getUuid());
        r.write("url", resourcePack.getUrl());
        r.write("prompt", resourcePack.getPrompt());
        r.write("hash", Hex.encodeHexString(resourcePack.getHash()));
        r.write("force", String.valueOf(resourcePack.isForce()));
        return r;
    }

    public static SingleSet<String, CosmicResourcePack> unbuild(ProxiedMessage messageIn) {
        byte[] hash;
        if (!messageIn.getSubChannel().equals(ResourcePackMessageBuilder.getSubChannel())) {
            MessageUtils.logWarning("Data mis-match on ProxyMessageIn for '" + ResourcePackMessageBuilder.class.getSimpleName() + "'. Continuing anyway...");
        }
        String uuid = messageIn.getString("user_uuid");
        String url = messageIn.getString("url");
        String prompt = messageIn.getString("url");
        String unparsed = messageIn.getString("hash");
        try {
            hash = unparsed.equals("") ? new byte[]{} : Hex.decodeHex(unparsed.toCharArray());
        }
        catch (Exception e) {
            e.printStackTrace();
            hash = new byte[]{};
        }
        boolean force = messageIn.getBoolean("force");
        return new SingleSet<String, CosmicResourcePack>(uuid, new CosmicResourcePack(url, hash, prompt, force));
    }

    public static String getSubChannel() {
        return subChannel;
    }
}

