/*
 * Decompiled with CFR 0.152.
 */
package singularity.messages.builders;

import java.util.List;
import singularity.Singularity;
import singularity.data.players.CosmicPlayer;
import singularity.messages.proxied.ProxiedMessage;
import singularity.modules.ModuleUtils;
import singularity.objects.CosmicServerInfo;
import singularity.utils.MessageUtils;

public class ServerConnectMessageBuilder {
    private static final String subChannel = "server-connect";
    private static final List<String> lines = List.of("identifier=%this_identifier%;", "user_uuid=%this_user_uuid%;");

    public static ProxiedMessage build(CosmicPlayer carrier, CosmicServerInfo serverInfo, String uuid) {
        ProxiedMessage r = new ProxiedMessage(carrier, false);
        r.setSubChannel(ServerConnectMessageBuilder.getSubChannel());
        r.write("user_uuid", uuid);
        r.write("identifier", serverInfo.getIdentifier());
        return r;
    }

    public static void handle(ProxiedMessage messageIn) {
        if (!messageIn.getSubChannel().equals(ServerConnectMessageBuilder.getSubChannel())) {
            MessageUtils.logWarning("Data mis-match on ProxyMessageIn for '" + ServerConnectMessageBuilder.class.getSimpleName() + "'.");
            return;
        }
        if (messageIn.isProxyOriginated()) {
            MessageUtils.logWarning("Tried to handle a ProxiedMessage with sub-channel '" + messageIn.getSubChannel() + "', but it was ProxyOriginated...");
            return;
        }
        String uuid = messageIn.getString("user_uuid");
        CosmicPlayer player = ModuleUtils.getOrCreatePlayer(uuid).orElse(null);
        if (player == null) {
            MessageUtils.logWarning("Failed to find player with UUID '" + uuid + "' for ServerConnectMessageBuilder.");
            return;
        }
        Singularity.getInstance().getUserManager().connect(player, messageIn.getString("identifier"));
    }

    public static String getSubChannel() {
        return subChannel;
    }

    public static List<String> getLines() {
        return lines;
    }
}

