/*
 * Decompiled with CFR 0.152.
 */
package singularity.permissions;

import java.util.Optional;
import singularity.data.players.CosmicPlayer;
import singularity.permissions.MetaGrabber;
import singularity.permissions.MetaKey;
import singularity.permissions.MetaValue;

public class PermissionUtil {
    private static Optional<MetaGrabber> optionalMetaGrabber = Optional.empty();

    public static Optional<MetaValue> getMeta(CosmicPlayer player, MetaKey key) {
        return optionalMetaGrabber.map(metaGrabber -> metaGrabber.getMeta(player, key)).filter(Optional::isPresent).map(Optional::get);
    }

    public static Optional<MetaValue> getPrefix(CosmicPlayer player) {
        return PermissionUtil.getMeta(player, MetaKey.PREFIX);
    }

    public static Optional<MetaValue> getSuffix(CosmicPlayer player) {
        return PermissionUtil.getMeta(player, MetaKey.SUFFIX);
    }

    public static void setMeta(MetaValue value) {
        optionalMetaGrabber.ifPresent(metaGrabber -> metaGrabber.setMeta(value));
    }

    public static void setPrefix(CosmicPlayer player, String prefix, long duration, int priority) {
        PermissionUtil.setMeta(new MetaValue(player.getIdentifier(), MetaKey.PREFIX, prefix, duration, priority));
    }

    public static void setSuffix(CosmicPlayer player, String suffix, long duration, int priority) {
        PermissionUtil.setMeta(new MetaValue(player.getIdentifier(), MetaKey.SUFFIX, suffix, duration, priority));
    }

    public static void setMetaGrabber(MetaGrabber metaGrabber) {
        optionalMetaGrabber = Optional.of(metaGrabber);
    }

    public static void removeMetaGrabber() {
        optionalMetaGrabber = Optional.empty();
    }

    public static Optional<MetaGrabber> getOptionalMetaGrabber() {
        return optionalMetaGrabber;
    }

    public static void setOptionalMetaGrabber(Optional<MetaGrabber> optionalMetaGrabber) {
        PermissionUtil.optionalMetaGrabber = optionalMetaGrabber;
    }
}

