/*
 * Decompiled with CFR 0.152.
 */
package singularity.placeholders.replaceables;

import gg.drak.thebase.utils.MatcherUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import singularity.placeholders.RATRegistry;
import singularity.placeholders.callbacks.RATCallback;
import singularity.placeholders.handling.RATHandledString;

public abstract class AbstractReplaceable<C extends RATCallback>
implements Comparable<AbstractReplaceable<?>> {
    private RATHandledString handledString;
    @Nullable
    private C callback;
    private int timesReplaced;

    public AbstractReplaceable(String string, int groups, @Nullable C callback) {
        this.handledString = new RATHandledString(string, groups);
        this.callback = callback;
        this.timesReplaced = 0;
    }

    public AbstractReplaceable(String from, @Nullable C callback) {
        this(MatcherUtils.makeLiteral(from), 0, callback);
    }

    public boolean isReplaceWorthy() {
        return this.getCallback() != null;
    }

    public boolean hasBeenTriggered() {
        return this.timesReplaced > 0;
    }

    public void addTimesReplaced(int times) {
        this.timesReplaced += times;
    }

    public void addTimesReplaced() {
        this.addTimesReplaced(1);
    }

    public void resetTimesReplaced() {
        this.timesReplaced = 0;
    }

    public void removeTimesReplaced(int times) {
        this.timesReplaced -= times;
    }

    public void removeTimesReplaced() {
        this.removeTimesReplaced(1);
    }

    public void register() {
        RATRegistry.register(this);
    }

    public void unregister() {
        RATRegistry.unregister(this);
    }

    @Override
    public int compareTo(@NotNull AbstractReplaceable<?> o) {
        String from = this.getHandledString().getRegex();
        String oFrom = o.getHandledString().getRegex();
        if (from == null && oFrom == null) {
            return 0;
        }
        if (from == null) {
            return -1;
        }
        if (oFrom == null) {
            return 1;
        }
        return CharSequence.compare(from, oFrom);
    }

    public void setHandledString(RATHandledString handledString) {
        this.handledString = handledString;
    }

    public void setCallback(@Nullable C callback) {
        this.callback = callback;
    }

    public void setTimesReplaced(int timesReplaced) {
        this.timesReplaced = timesReplaced;
    }

    public RATHandledString getHandledString() {
        return this.handledString;
    }

    @Nullable
    public C getCallback() {
        return this.callback;
    }

    public int getTimesReplaced() {
        return this.timesReplaced;
    }
}

