/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.libs.logback.classic.joran;

import host.plas.bou.libs.logback.classic.LoggerContext;
import host.plas.bou.libs.logback.classic.joran.ModelClassToModelHandlerLinker;
import host.plas.bou.libs.logback.classic.joran.serializedModel.HardenedModelInputStream;
import host.plas.bou.libs.logback.classic.model.processor.LogbackClassicDefaultNestedComponentRules;
import host.plas.bou.libs.logback.classic.spi.Configurator;
import host.plas.bou.libs.logback.classic.spi.ConfiguratorRank;
import host.plas.bou.libs.logback.core.LogbackException;
import host.plas.bou.libs.logback.core.model.Model;
import host.plas.bou.libs.logback.core.model.ModelUtil;
import host.plas.bou.libs.logback.core.model.processor.DefaultProcessor;
import host.plas.bou.libs.logback.core.model.processor.ModelInterpretationContext;
import host.plas.bou.libs.logback.core.spi.ContextAwareBase;
import host.plas.bou.libs.logback.core.status.InfoStatus;
import host.plas.bou.libs.logback.core.status.StatusManager;
import host.plas.bou.libs.logback.core.util.Loader;
import host.plas.bou.libs.logback.core.util.OptionHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

@ConfiguratorRank(value=10)
public class SerializedModelConfigurator
extends ContextAwareBase
implements Configurator {
    public static final String AUTOCONFIG_MODEL_FILE = "logback.scmo";
    public static final String TEST_AUTOCONFIG_MODEL_FILE = "logback-test.scmo";
    protected ModelInterpretationContext modelInterpretationContext;

    @Override
    public Configurator.ExecutionStatus configure(LoggerContext loggerContext) {
        URL url = this.performMultiStepModelFileSearch(true);
        if (url != null) {
            this.configureByResource(url);
            return Configurator.ExecutionStatus.DO_NOT_INVOKE_NEXT_IF_ANY;
        }
        return Configurator.ExecutionStatus.INVOKE_NEXT_IF_ANY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureByResource(URL url) {
        String urlString = url.toString();
        if (urlString.endsWith(".scmo")) {
            Model model = this.retrieveModel(url);
            if (model == null) {
                this.addWarn("Empty model. Abandoning.");
                return;
            }
            ModelUtil.resetForReuse(model);
            this.buildModelInterpretationContext(model);
            DefaultProcessor defaultProcessor = new DefaultProcessor(this.context, this.modelInterpretationContext);
            ModelClassToModelHandlerLinker mc2mhl = new ModelClassToModelHandlerLinker(this.context);
            mc2mhl.link(defaultProcessor);
            Object object = this.context.getConfigurationLock();
            synchronized (object) {
                defaultProcessor.process(model);
            }
        } else {
            throw new LogbackException("Unexpected filename extension of file [" + url.toString() + "]. Should be .scmo");
        }
    }

    private void buildModelInterpretationContext(Model topModel) {
        this.modelInterpretationContext = new ModelInterpretationContext(this.context, this);
        this.modelInterpretationContext.setTopModel(topModel);
        LogbackClassicDefaultNestedComponentRules.addDefaultNestedComponentRegistryRules(this.modelInterpretationContext.getDefaultNestedComponentRegistry());
        this.modelInterpretationContext.createAppenderBags();
    }

    private Model retrieveModel(URL url) {
        block10: {
            Model model;
            block9: {
                long start = System.currentTimeMillis();
                InputStream is = url.openStream();
                try {
                    HardenedModelInputStream hmis = new HardenedModelInputStream(is);
                    Model model2 = (Model)hmis.readObject();
                    long diff = System.currentTimeMillis() - start;
                    this.addInfo("Model at [" + String.valueOf(url) + "] read in " + diff + " milliseconds");
                    model = model2;
                    if (is == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        this.addError("Failed to open " + String.valueOf(url), e);
                        break block10;
                    }
                    catch (ClassNotFoundException e) {
                        this.addError("Failed read model object in " + String.valueOf(url), e);
                    }
                }
                is.close();
            }
            return model;
        }
        return null;
    }

    private URL performMultiStepModelFileSearch(boolean updateState) {
        ClassLoader myClassLoader = Loader.getClassLoaderOfObject(this);
        URL url = this.findModelConfigFileURLFromSystemProperties(myClassLoader);
        if (url != null) {
            return url;
        }
        url = this.getResource(TEST_AUTOCONFIG_MODEL_FILE, myClassLoader, updateState);
        if (url != null) {
            return url;
        }
        url = this.getResource(AUTOCONFIG_MODEL_FILE, myClassLoader, updateState);
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    URL findModelConfigFileURLFromSystemProperties(ClassLoader classLoader) {
        String logbackModelFile = OptionHelper.getSystemProperty("logback.scmoFile");
        if (logbackModelFile != null) {
            URL result = null;
            try {
                URL uRL = result = new URL(logbackModelFile);
                return uRL;
            }
            catch (MalformedURLException e) {
                result = Loader.getResource(logbackModelFile, classLoader);
                if (result != null) {
                    URL uRL = result;
                    return uRL;
                }
                File f = new File(logbackModelFile);
                if (f.exists() && f.isFile()) {
                    try {
                        URL uRL = result = f.toURI().toURL();
                        return uRL;
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
            }
            finally {
                this.statusOnResourceSearch(logbackModelFile, result);
            }
        }
        return null;
    }

    private URL getResource(String filename, ClassLoader classLoader, boolean updateStatus) {
        URL url = Loader.getResource(filename, classLoader);
        if (updateStatus) {
            this.statusOnResourceSearch(filename, url);
        }
        return url;
    }

    private void statusOnResourceSearch(String resourceName, URL url) {
        StatusManager sm = this.context.getStatusManager();
        if (url == null) {
            sm.add(new InfoStatus("Could NOT find resource [" + resourceName + "]", this.context));
        } else {
            sm.add(new InfoStatus("Found resource [" + resourceName + "] at [" + url.toString() + "]", this.context));
        }
    }
}

