/*
 * Decompiled with CFR 0.152.
 */
package host.plas.bou.libs.logback.classic.model.processor;

import host.plas.bou.libs.logback.classic.LoggerContext;
import host.plas.bou.libs.logback.classic.model.ConfigurationModel;
import host.plas.bou.libs.logback.core.Context;
import host.plas.bou.libs.logback.core.model.Model;
import host.plas.bou.libs.logback.core.model.processor.ModelHandlerBase;
import host.plas.bou.libs.logback.core.model.processor.ModelInterpretationContext;
import host.plas.bou.libs.logback.core.status.OnConsoleStatusListener;
import host.plas.bou.libs.logback.core.util.ContextUtil;
import host.plas.bou.libs.logback.core.util.Duration;
import host.plas.bou.libs.logback.core.util.OptionHelper;
import host.plas.bou.libs.logback.core.util.StatusListenerConfigHelper;

public class ConfigurationModelHandler
extends ModelHandlerBase {
    static final Duration SCAN_PERIOD_DEFAULT = Duration.buildByMinutes(1.0);

    public ConfigurationModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext mic) {
        return new ConfigurationModelHandler(context);
    }

    protected Class<ConfigurationModel> getSupportedModelClass() {
        return ConfigurationModel.class;
    }

    @Override
    public void handle(ModelInterpretationContext mic, Model model) {
        ConfigurationModel configurationModel = (ConfigurationModel)model;
        String debugAttrib = OptionHelper.getSystemProperty("logback.debug", null);
        if (debugAttrib == null) {
            debugAttrib = mic.subst(configurationModel.getDebugStr());
        }
        if (!(OptionHelper.isNullOrEmptyOrAllSpaces(debugAttrib) || debugAttrib.equalsIgnoreCase(Boolean.FALSE.toString()) || debugAttrib.equalsIgnoreCase("null"))) {
            StatusListenerConfigHelper.addOnConsoleListenerInstance(this.context, new OnConsoleStatusListener());
        }
        this.processScanAttrib(mic, configurationModel);
        LoggerContext lc = (LoggerContext)this.context;
        boolean packagingData = OptionHelper.toBoolean(mic.subst(configurationModel.getPackagingDataStr()), false);
        lc.setPackagingDataEnabled(packagingData);
        ContextUtil contextUtil = new ContextUtil(this.context);
        contextUtil.addGroovyPackages(lc.getFrameworkPackages());
    }

    protected void processScanAttrib(ModelInterpretationContext mic, ConfigurationModel configurationModel) {
        String scanStr = mic.subst(configurationModel.getScanStr());
        if (!OptionHelper.isNullOrEmptyOrAllSpaces(scanStr) && !"false".equalsIgnoreCase(scanStr)) {
            this.addInfo("Skipping ReconfigureOnChangeTask registration");
        }
    }
}

