/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.protocol;

import io.lettuce.core.internal.LettuceAssert;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

class SharedLock {
    private static final AtomicLongFieldUpdater<SharedLock> WRITERS = AtomicLongFieldUpdater.newUpdater(SharedLock.class, "writers");
    private final Lock lock = new ReentrantLock();
    private final ThreadLocal<Integer> threadWriters = ThreadLocal.withInitial(() -> 0);
    private volatile long writers = 0L;
    private volatile Thread exclusiveLockOwner;

    SharedLock() {
    }

    void incrementWriters() {
        if (this.exclusiveLockOwner == Thread.currentThread()) {
            return;
        }
        this.lock.lock();
        try {
            while (WRITERS.get(this) < 0L) {
            }
            WRITERS.incrementAndGet(this);
            this.threadWriters.set(this.threadWriters.get() + 1);
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    void decrementWriters() {
        if (this.exclusiveLockOwner == Thread.currentThread()) {
            return;
        }
        WRITERS.decrementAndGet(this);
        this.threadWriters.set(this.threadWriters.get() - 1);
    }

    void doExclusive(Runnable runnable) {
        LettuceAssert.notNull((Object)runnable, "Runnable must not be null");
        this.doExclusive(() -> {
            runnable.run();
            return null;
        });
    }

    <T> T doExclusive(Supplier<T> supplier) {
        LettuceAssert.notNull(supplier, "Supplier must not be null");
        this.lock.lock();
        try {
            T t2;
            try {
                this.lockWritersExclusive();
                t2 = supplier.get();
                this.unlockWritersExclusive();
            }
            catch (Throwable throwable) {
                this.unlockWritersExclusive();
                throw throwable;
            }
            return t2;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void lockWritersExclusive() {
        if (this.exclusiveLockOwner == Thread.currentThread()) {
            WRITERS.decrementAndGet(this);
            return;
        }
        this.lock.lock();
        try {
            while (!WRITERS.compareAndSet(this, this.threadWriters.get().intValue(), -1L)) {
            }
            this.exclusiveLockOwner = Thread.currentThread();
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void unlockWritersExclusive() {
        if (this.exclusiveLockOwner == Thread.currentThread()) {
            if (WRITERS.compareAndSet(this, -1L, this.threadWriters.get().intValue())) {
                this.exclusiveLockOwner = null;
                return;
            }
            WRITERS.incrementAndGet(this);
        }
    }
}

