/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.search.arguments;

import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;

public class SortByArgs<K> {
    private K attribute;
    private boolean isDescending;
    private boolean withCount;

    public static <K> Builder<K> builder() {
        return new Builder();
    }

    public void build(CommandArgs<K, ?> args) {
        args.add(CommandKeyword.SORTBY).addKey(this.attribute);
        if (this.isDescending) {
            args.add(CommandKeyword.DESC);
        }
        if (this.withCount) {
            args.add(CommandKeyword.WITHCOUNT);
        }
    }

    public static class Builder<K> {
        private final SortByArgs<K> sortByArgs = new SortByArgs();

        public Builder<K> attribute(K attribute) {
            ((SortByArgs)this.sortByArgs).attribute = attribute;
            return this;
        }

        public Builder<K> descending() {
            ((SortByArgs)this.sortByArgs).isDescending = true;
            return this;
        }

        public Builder<K> withCount() {
            ((SortByArgs)this.sortByArgs).withCount = true;
            return this;
        }

        public SortByArgs<K> build() {
            return this.sortByArgs;
        }
    }
}

