/*
 * Decompiled with CFR 0.152.
 */
package mc.obliviate.util.placeholder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mc.obliviate.util.placeholder.InternalPlaceholder;

public class PlaceholderUtil {
    private final Set<InternalPlaceholder> placeholders = new HashSet<InternalPlaceholder>();

    public PlaceholderUtil add(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        this.placeholders.add(new InternalPlaceholder(key, value));
        return this;
    }

    public Set<InternalPlaceholder> getPlaceholders() {
        return this.placeholders;
    }

    public void merge(PlaceholderUtil placeholderUtil) {
        if (placeholderUtil == null) {
            return;
        }
        this.placeholders.addAll(new ArrayList<InternalPlaceholder>(placeholderUtil.placeholders));
    }

    public List<String> apply(Iterable<String> texts) {
        if (texts == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String text : texts) {
            result.add(this.apply(text));
        }
        return result;
    }

    public String apply(String text) {
        if (text == null) {
            return null;
        }
        for (InternalPlaceholder placeholder : this.placeholders) {
            text = text.replace(placeholder.getPlaceholder(), placeholder.getValue());
        }
        return text;
    }

    public static String apply(String text, PlaceholderUtil placeholderUtil) {
        if (placeholderUtil == null) {
            return text;
        }
        return placeholderUtil.apply(text);
    }

    public static List<String> apply(Iterable<String> texts, PlaceholderUtil placeholderUtil) {
        if (placeholderUtil == null) {
            if (texts instanceof List) {
                return (List)texts;
            }
            ArrayList<String> list = new ArrayList<String>();
            for (String text : texts) {
                list.add(text);
            }
            return list;
        }
        return placeholderUtil.apply(texts);
    }
}

