/*
 * Decompiled with CFR 0.152.
 */
package net.streamline.api.permissions;

import java.util.UUID;
import net.luckperms.api.node.Node;
import net.streamline.api.SLAPI;
import singularity.utils.UuidUtils;

public class LuckPermsHandler {
    public static void addPermission(String uuid, String permission) {
        String sUuid = UuidUtils.toUuid(uuid);
        if (sUuid == null) {
            return;
        }
        UUID playerUuid = UUID.fromString(sUuid);
        SLAPI.getLpOptional().ifPresent(lp -> lp.getUserManager().modifyUser(playerUuid, user -> user.data().add((Node)Node.builder((String)permission).build())));
    }

    public static void removePermission(String uuid, String permission) {
        String sUuid = UuidUtils.toUuid(uuid);
        if (sUuid == null) {
            return;
        }
        UUID playerUuid = UUID.fromString(sUuid);
        SLAPI.getLpOptional().ifPresent(lp -> lp.getUserManager().modifyUser(playerUuid, user -> user.data().remove((Node)Node.builder((String)permission).build())));
    }

    public static boolean hasLuckPerms() {
        return SLAPI.getLpOptional().isPresent();
    }
}

