/*
 * Decompiled with CFR 0.152.
 */
package net.streamline.base;

import host.plas.bou.libs.universalScheduler.scheduling.tasks.MyScheduledTask;
import net.streamline.base.StreamlineSpigot;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import singularity.data.players.CosmicPlayer;
import singularity.data.players.location.CosmicLocation;
import singularity.data.players.location.PlayerRotation;
import singularity.data.players.location.PlayerWorld;
import singularity.data.players.location.WorldPosition;
import singularity.data.server.CosmicServer;
import singularity.messages.builders.PlayerLocationMessageBuilder;
import singularity.utils.UserUtils;

public class TenSecondTimer
implements Runnable {
    final Player player;
    final MyScheduledTask task;

    public TenSecondTimer(Player player) {
        this.player = player;
        this.task = StreamlineSpigot.getScheduler().runTaskTimerAsynchronously((Runnable)this, 40L, 40L);
    }

    @Override
    public void run() {
        if (!this.checkPlayer()) {
            return;
        }
        CosmicPlayer streamPlayer = UserUtils.getOrCreatePlayer(this.player.getUniqueId().toString()).orElse(null);
        if (streamPlayer == null) {
            this.task.cancel();
            return;
        }
        CosmicServer cosmicServer = streamPlayer.getServer();
        Location location = this.player.getLocation();
        World world = location.getWorld();
        if (world == null) {
            world = (World)Bukkit.getWorlds().get(0);
        }
        PlayerWorld streamlineWorld = new PlayerWorld(world.getName());
        WorldPosition streamlinePosition = new WorldPosition(location.getX(), location.getY(), location.getZ());
        PlayerRotation streamlineRotation = new PlayerRotation(location.getYaw(), location.getPitch());
        CosmicLocation streamlineLocation = new CosmicLocation(cosmicServer, streamlineWorld, streamlinePosition, streamlineRotation);
        streamPlayer.setLocation(streamlineLocation);
        PlayerLocationMessageBuilder.build(streamPlayer, streamlineLocation, streamPlayer).send();
    }

    public boolean checkPlayer() {
        if (this.player == null) {
            this.task.cancel();
            return false;
        }
        if (!this.player.isOnline()) {
            this.task.cancel();
            return false;
        }
        return true;
    }

    public Player getPlayer() {
        return this.player;
    }

    public MyScheduledTask getTask() {
        return this.task;
    }
}

