/*
 * Decompiled with CFR 0.152.
 */
package net.streamline.platform;

import host.plas.bou.commands.Sender;
import host.plas.bou.utils.ColorUtils;
import host.plas.bou.utils.SenderUtils;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.streamline.api.SLAPI;
import net.streamline.base.StreamlineSpigot;
import net.streamline.platform.savables.UserManager;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;
import singularity.data.console.CosmicSender;
import singularity.data.players.CosmicPlayer;
import singularity.interfaces.IMessenger;
import singularity.objects.CosmicTitle;
import singularity.utils.MessageUtils;

public class Messenger
implements IMessenger {
    private static Messenger instance;

    public Messenger() {
        instance = this;
    }

    @Deprecated
    public static String colorAsString(String message) {
        return Messenger.colorAsStringBOU(message);
    }

    @Deprecated
    public static String colorAsStringBOU(String message) {
        return host.plas.bou.utils.MessageUtils.codedString((String)message);
    }

    public void sendMessage(@Nullable CommandSender to, String message) {
        if (to == null) {
            return;
        }
        Sender s2 = SenderUtils.getSender((CommandSender)to);
        if (!SLAPI.isReady()) {
            s2.sendMessage(message);
        } else {
            s2.sendMessage(this.replaceAllPlayerBungee(to, message));
        }
    }

    public void sendMessage(@Nullable CommandSender to, String otherUUID, String message) {
        if (to == null) {
            return;
        }
        Sender s2 = SenderUtils.getSender((CommandSender)to);
        if (!SLAPI.isReady()) {
            s2.sendMessage(message);
        } else {
            s2.sendMessage(MessageUtils.replaceAllPlayerBungee(otherUUID, message));
        }
    }

    public void sendMessage(@Nullable CommandSender to, CosmicSender other, String message) {
        if (to == null) {
            return;
        }
        Sender s2 = SenderUtils.getSender((CommandSender)to);
        if (!SLAPI.isReady()) {
            s2.sendMessage(message);
        } else {
            s2.sendMessage(MessageUtils.replaceAllPlayerBungee(other, message));
        }
    }

    @Override
    public void sendMessage(@Nullable CosmicSender to, String message) {
        if (to == null) {
            return;
        }
        if (to instanceof CosmicPlayer) {
            this.sendMessage((CommandSender)Bukkit.getPlayer((UUID)UUID.fromString(to.getUuid())), message);
        } else {
            this.sendMessage((CommandSender)Bukkit.getConsoleSender(), message);
        }
    }

    @Override
    public void sendMessage(@Nullable CosmicSender to, String otherUUID, String message) {
        if (to == null) {
            return;
        }
        if (to instanceof CosmicPlayer) {
            this.sendMessage((CommandSender)Bukkit.getPlayer((UUID)UUID.fromString(to.getUuid())), otherUUID, message);
        } else {
            this.sendMessage((CommandSender)Bukkit.getConsoleSender(), otherUUID, message);
        }
    }

    @Override
    public void sendMessage(@Nullable CosmicSender to, CosmicSender other, String message) {
        if (to == null || other == null) {
            return;
        }
        if (to instanceof CosmicPlayer) {
            this.sendMessage((CommandSender)Bukkit.getPlayer((UUID)UUID.fromString(to.getUuid())), other, message);
        } else {
            this.sendMessage((CommandSender)Bukkit.getConsoleSender(), other, message);
        }
    }

    public void sendMessageRaw(CommandSender to, String message) {
        if (to == null) {
            return;
        }
        String r = message;
        if (SLAPI.isReady()) {
            r = this.replaceAllPlayerBungee(to, message);
        }
        to.sendMessage(r);
    }

    public void sendMessageRaw(CommandSender to, String otherUUID, String message) {
        if (to == null) {
            return;
        }
        String r = message;
        if (SLAPI.isReady()) {
            r = MessageUtils.replaceAllPlayerBungee(otherUUID, message);
        }
        to.sendMessage(r);
    }

    public void sendMessageRaw(CommandSender to, CosmicSender other, String message) {
        if (to == null) {
            return;
        }
        String r = message;
        if (SLAPI.isReady()) {
            r = MessageUtils.replaceAllPlayerBungee(other, message);
        }
        to.sendMessage(r);
    }

    @Override
    public void sendMessageRaw(@Nullable CosmicSender to, String message) {
        if (to == null) {
            return;
        }
        if (to instanceof CosmicPlayer) {
            this.sendMessageRaw((CommandSender)Bukkit.getPlayer((UUID)UUID.fromString(to.getUuid())), message);
        } else {
            this.sendMessageRaw((CommandSender)Bukkit.getConsoleSender(), message);
        }
    }

    @Override
    public void sendMessageRaw(@Nullable CosmicSender to, String otherUUID, String message) {
        if (to == null) {
            return;
        }
        if (to instanceof CosmicPlayer) {
            this.sendMessageRaw((CommandSender)Bukkit.getPlayer((UUID)UUID.fromString(to.getUuid())), otherUUID, message);
        } else {
            this.sendMessageRaw((CommandSender)Bukkit.getConsoleSender(), otherUUID, message);
        }
    }

    @Override
    public void sendMessageRaw(@Nullable CosmicSender to, CosmicSender other, String message) {
        if (to == null || other == null) {
            return;
        }
        if (to instanceof CosmicPlayer) {
            this.sendMessageRaw((CommandSender)Bukkit.getPlayer((UUID)UUID.fromString(to.getUuid())), other, message);
        } else {
            this.sendMessageRaw((CommandSender)Bukkit.getConsoleSender(), other, message);
        }
    }

    @Override
    public void sendTitle(CosmicSender player, CosmicTitle title) {
        Player p = StreamlineSpigot.getPlayer(player.getUuid());
        if (p == null) {
            MessageUtils.logInfo("Could not send a title to a player because player is null!");
            return;
        }
        p.sendTitle(title.getMain(), title.getSub(), (int)title.getFadeIn(), (int)title.getStay(), (int)title.getFadeOut());
    }

    @Override
    public String codedString(String from) {
        return this.codedStringBOU(from);
    }

    @Override
    public String stripColor(String string) {
        return ChatColor.stripColor((String)string).replaceAll("([<][#][1-9a-f][1-9a-f][1-9a-f][1-9a-f][1-9a-f][1-9a-f][>])+", "");
    }

    public String codedStringBOU(String value) {
        return host.plas.bou.utils.MessageUtils.codedString((String)value);
    }

    public BaseComponent[] colorizeBOU(String value) {
        return ColorUtils.color((String)value);
    }

    public BaseComponent[] codedText(String from) {
        return this.colorizeBOU(from);
    }

    public String colorizeHard(String value) {
        return ColorUtils.colorizeHard((String)value);
    }

    public String replaceAllPlayerBungee(CommandSender sender, String of) {
        CosmicSender s2 = UserManager.getInstance().getOrCreateSender(sender).orElse(null);
        if (s2 == null) {
            return of;
        }
        return MessageUtils.replaceAllPlayerBungee(s2, of);
    }

    public static Messenger getInstance() {
        return instance;
    }
}

