/*
 * Decompiled with CFR 0.152.
 */
package net.streamline.platform.commands;

import host.plas.bou.utils.SenderUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Collectors;
import net.streamline.base.StreamlineSpigot;
import net.streamline.platform.savables.UserManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.command.defaults.BukkitCommand;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import singularity.command.CosmicCommand;
import singularity.command.result.CommandResult;
import singularity.data.console.CosmicSender;
import singularity.interfaces.IProperCommand;
import singularity.utils.MessageUtils;

public class ProperCommand
extends BukkitCommand
implements TabExecutor,
IProperCommand {
    private final CosmicCommand parent;

    public ProperCommand(CosmicCommand parent) {
        super(parent.getBase(), "Not defined.", "Not defined.", List.of(parent.getAliases()));
        this.parent = parent;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        return this.execute(sender, label, args);
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        try {
            CosmicSender s2;
            if (args == null) {
                args = new String[]{""};
            }
            if (args.length < 1) {
                args = new String[]{""};
            }
            if ((s2 = (CosmicSender)UserManager.getInstance().getOrCreateSender(sender).orElse(null)) == null) {
                MessageUtils.logWarning("Cannot tab complete for command '" + label + "' as the sender is not a CosmicSender.");
                return new ArrayList<String>();
            }
            ConcurrentSkipListSet<String> r = this.parent.baseTabComplete(s2, args);
            return r == null ? new ArrayList<String>() : new ArrayList<String>(MessageUtils.getCompletion(r, args[args.length - 1]));
        }
        catch (Throwable e) {
            MessageUtils.logWarning("An error occurred while tab completing command '" + label + "': " + e.getMessage());
            e.printStackTrace();
            return new ArrayList<String>();
        }
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull @NotNull String @NotNull [] args) throws IllegalArgumentException {
        try {
            List<String> completions = this.onTabComplete(sender, (Command)this, alias, args);
            if (completions == null) {
                return new ArrayList<String>();
            }
            return completions.stream().filter(Objects::nonNull).map(String::trim).filter(s2 -> !s2.isEmpty()).collect(Collectors.toList());
        }
        catch (Throwable e) {
            MessageUtils.logWarning("An error occurred while tab completing command '" + alias + "': " + e.getMessage());
            e.printStackTrace();
            return new ArrayList<String>();
        }
    }

    @Override
    public void register() {
        try {
            StreamlineSpigot.registerCommands(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void unregister() {
        try {
            StreamlineSpigot.unregisterCommands(this.getParent().getBase());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] args) {
        try {
            CosmicSender s2 = UserManager.getInstance().getOrCreateSender(sender).orElse(null);
            if (s2 == null) {
                MessageUtils.logWarning("Cannot execute command '" + commandLabel + "' as the sender is not a CosmicSender.");
                return false;
            }
            CommandResult<?> result = this.parent.baseRun(s2, args);
            if (result == null) {
                return false;
            }
            if (result == CosmicCommand.notSet()) {
                return true;
            }
            if (result == CosmicCommand.error()) {
                return false;
            }
            if (result == CosmicCommand.failure()) {
                return false;
            }
            return result == CosmicCommand.success();
        }
        catch (Throwable e) {
            SenderUtils.getSender((CommandSender)sender).sendMessage("&cAn error occurred while executing the command &7'&e" + commandLabel + "&7'&8. &cPlease tell an admin to check the console.");
            MessageUtils.logWarning("An error occurred while executing command '" + commandLabel + "': " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public CosmicCommand getParent() {
        return this.parent;
    }
}

