/*
 * Decompiled with CFR 0.152.
 */
package net.streamline.platform.listeners;

import gg.drak.thebase.events.BaseEventHandler;
import gg.drak.thebase.events.BaseEventListener;
import gg.drak.thebase.events.components.BaseEvent;
import gg.drak.thebase.events.processing.BaseProcessor;
import host.plas.bou.utils.ClassHelper;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import net.streamline.api.SLAPI;
import net.streamline.base.StreamlineSpigot;
import net.streamline.base.TenSecondTimer;
import net.streamline.platform.Messenger;
import net.streamline.platform.events.ProperEvent;
import net.streamline.platform.listeners.PaperListener;
import net.streamline.platform.savables.UserManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.bukkit.util.CachedServerIcon;
import org.jetbrains.annotations.NotNull;
import singularity.configs.given.GivenConfigs;
import singularity.configs.given.MainMessagesHandler;
import singularity.configs.given.whitelist.WhitelistConfig;
import singularity.configs.given.whitelist.WhitelistEntry;
import singularity.data.players.CosmicPlayer;
import singularity.data.players.location.CosmicLocation;
import singularity.data.players.location.PlayerRotation;
import singularity.data.players.location.PlayerWorld;
import singularity.data.players.location.WorldPosition;
import singularity.data.uuid.UuidManager;
import singularity.events.player.location.PlayerMovementEvent;
import singularity.events.server.CosmicChatEvent;
import singularity.events.server.LoginCompletedEvent;
import singularity.events.server.LoginReceivedEvent;
import singularity.events.server.LogoutEvent;
import singularity.events.server.ServerStartEvent;
import singularity.events.server.ping.PingReceivedEvent;
import singularity.events.server.world.BlockPlaceEvent;
import singularity.messages.events.ProxyMessageInEvent;
import singularity.messages.proxied.ProxiedMessage;
import singularity.modules.ModuleManager;
import singularity.modules.ModuleUtils;
import singularity.objects.PingedResponse;
import singularity.objects.world.CosmicBlock;
import singularity.utils.MessageUtils;
import singularity.utils.UserUtils;

public class PlatformListener
implements Listener {
    private static boolean messaged = false;
    private static boolean joined = false;
    private static BaseProcessorListener processorListener;
    public static PaperListener paperListener;

    public static boolean isTested() {
        return PlatformListener.isMessaged() && PlatformListener.isJoined();
    }

    public PlatformListener() {
        MessageUtils.logInfo("BaseListener registered!");
        PlatformListener.setProcessorListener(new BaseProcessorListener());
        ModuleUtils.listen(PlatformListener.getProcessorListener(), SLAPI.getBaseModule());
        if (ClassHelper.isPaper()) {
            paperListener = new PaperListener();
        }
    }

    @EventHandler
    public void onPreJoin(AsyncPlayerPreLoginEvent event) {
        WhitelistEntry entry;
        String uuid = event.getUniqueId().toString();
        CosmicPlayer streamPlayer = UserUtils.getOrGetPlayer(uuid).orElse(null);
        if (streamPlayer == null) {
            return;
        }
        streamPlayer.waitUntilFullyLoaded();
        WhitelistConfig whitelistConfig = GivenConfigs.getWhitelistConfig();
        if (whitelistConfig.isEnabled() && (entry = whitelistConfig.getEntry(streamPlayer.getUuid())) == null) {
            event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_WHITELIST, MessageUtils.codedString(MainMessagesHandler.MESSAGES.INVALID.WHITELIST_NOT.get()));
            return;
        }
        LoginReceivedEvent loginReceivedEvent = new LoginReceivedEvent(streamPlayer);
        BaseEventHandler.fireEvent((BaseEvent)loginReceivedEvent);
        if (loginReceivedEvent.getResult().isCancelled()) {
            if (!loginReceivedEvent.getResult().validate()) {
                return;
            }
            event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_OTHER, MessageUtils.codedString(loginReceivedEvent.getResult().getDisconnectMessage()));
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UuidManager.cachePlayer(player.getUniqueId().toString(), player.getName(), UserManager.getInstance().parsePlayerIP(player));
        CosmicPlayer streamPlayer = UserUtils.getOrCreatePlayer(player.getUniqueId().toString()).orElse(null);
        if (streamPlayer == null) {
            MessageUtils.logWarning("Failed to create CosmicPlayer for " + player.getName() + " (" + String.valueOf(player.getUniqueId()) + ")");
            return;
        }
        streamPlayer.setCurrentIp(UserManager.getInstance().parsePlayerIP(player));
        streamPlayer.setCurrentName(player.getName());
        CosmicLocation location = streamPlayer.getLocation();
        Location loc = player.getLocation();
        World w = loc.getWorld();
        if (w != null) {
            PlayerWorld world = new PlayerWorld(w.getName());
            WorldPosition position = new WorldPosition(loc.getX(), loc.getY(), loc.getZ());
            PlayerRotation rotation = new PlayerRotation(loc.getYaw(), loc.getPitch());
            CosmicLocation newLocation = new CosmicLocation(location.getServer(), world, position, rotation);
            streamPlayer.setLocation(newLocation);
            streamPlayer.save();
        }
        LoginCompletedEvent loginCompletedEvent = new LoginCompletedEvent(streamPlayer);
        ModuleUtils.fireEvent(loginCompletedEvent);
        PlatformListener.setJoined(true);
        new TenSecondTimer(player);
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        UuidManager.cachePlayer(player.getUniqueId().toString(), player.getName(), UserManager.getInstance().parsePlayerIP(player.getUniqueId().toString()));
        CosmicPlayer streamPlayer = UserUtils.getOrCreatePlayer(player.getUniqueId().toString()).orElse(null);
        if (streamPlayer == null) {
            MessageUtils.logWarning("Failed to create CosmicPlayer for " + player.getName() + " (" + String.valueOf(player.getUniqueId()) + ")");
            return;
        }
        LogoutEvent logoutEvent = new LogoutEvent(streamPlayer);
        ModuleUtils.fireEvent(logoutEvent);
        streamPlayer.save();
        UserUtils.unloadSender(streamPlayer);
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        CosmicPlayer streamPlayer = UserUtils.getOrCreatePlayer(player.getUniqueId().toString()).orElse(null);
        if (streamPlayer == null) {
            MessageUtils.logWarning("Failed to create CosmicPlayer for " + player.getName() + " (" + String.valueOf(player.getUniqueId()) + ")");
            return;
        }
        CosmicChatEvent chatEvent = new CosmicChatEvent(streamPlayer, event.getMessage());
        StreamlineSpigot.getInstance().fireEvent(chatEvent, true);
        if (chatEvent.isCanceled()) {
            event.setCancelled(true);
            return;
        }
        event.setMessage(chatEvent.getMessage());
    }

    @EventHandler
    public void onProperEvent(ProperEvent event) {
        ModuleManager.fireEvent(event.getCosmicEvent());
    }

    @EventHandler
    public void onStart(ServerLoadEvent event) {
        ServerStartEvent e = (ServerStartEvent)new ServerStartEvent().fire();
        if (e.isCancelled()) {
            return;
        }
        if (!e.isSendable()) {
            return;
        }
        SLAPI.sendConsoleMessage(e.getMessage());
    }

    @EventHandler
    public void onPing(ServerListPingEvent event) {
        PingedResponse response;
        String hostName;
        if (ClassHelper.isPaper()) {
            return;
        }
        try {
            hostName = event.getAddress().getHostName();
        }
        catch (Throwable e) {
            hostName = "";
        }
        PingedResponse.Protocol protocol = new PingedResponse.Protocol("latest", 1);
        ArrayList<PingedResponse.PlayerInfo> playerInfos = new ArrayList<PingedResponse.PlayerInfo>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            playerInfos.add(new PingedResponse.PlayerInfo(player.getName(), player.getUniqueId().toString()));
        }
        PingedResponse.Players players = new PingedResponse.Players(event.getMaxPlayers(), event.getNumPlayers(), playerInfos.toArray(new PingedResponse.PlayerInfo[0]));
        try {
            response = new PingedResponse(protocol, players, event.getMotd());
        }
        catch (Throwable e) {
            StreamlineSpigot.getInstance().logWarning("Failed to create PingedResponse: " + e.getMessage());
            StreamlineSpigot.getInstance().logWarning(e.getStackTrace());
            return;
        }
        PingReceivedEvent pingReceivedEvent = (PingReceivedEvent)new PingReceivedEvent(response, hostName).fire();
        if (pingReceivedEvent.isCancelled()) {
            return;
        }
        event.setMotd(Messenger.getInstance().codedString(pingReceivedEvent.getResponse().getDescription()));
        event.setMaxPlayers(pingReceivedEvent.getResponse().getPlayers().getMax());
        try {
            CachedServerIcon icon = Bukkit.loadServerIcon((File)Paths.get(pingReceivedEvent.getResponse().getFaviconString(), new String[0]).toFile());
            event.setServerIcon(icon);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        CosmicPlayer streamPlayer = UserUtils.getOrCreatePlayer(player.getUniqueId().toString()).orElse(null);
        if (streamPlayer == null) {
            return;
        }
        Location loc = event.getTo();
        if (loc == null) {
            return;
        }
        if (loc.getWorld() == null) {
            return;
        }
        CosmicLocation location = streamPlayer.getLocation();
        PlayerWorld world = new PlayerWorld(loc.getWorld().getName());
        WorldPosition position = new WorldPosition(loc.getX(), loc.getY(), loc.getZ());
        PlayerRotation rotation = new PlayerRotation(loc.getYaw(), loc.getPitch());
        CosmicLocation newLocation = new CosmicLocation(location.getServer(), world, position, rotation);
        PlayerMovementEvent e = (PlayerMovementEvent)new PlayerMovementEvent(streamPlayer, newLocation).fire();
        if (e.isCancelled()) {
            event.setCancelled(true);
            return;
        }
        streamPlayer.setLocation(e.getNewLocation());
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        WorldPosition location;
        Player player = event.getPlayer();
        Block block = event.getBlock();
        CosmicPlayer streamPlayer = UserUtils.getOrCreatePlayer(player.getUniqueId().toString()).orElse(null);
        if (streamPlayer == null) {
            MessageUtils.logWarning("Failed to create CosmicPlayer for " + player.getName() + " (" + String.valueOf(player.getUniqueId()) + ")");
            return;
        }
        PlayerWorld world = new PlayerWorld(player.getWorld().getName());
        CosmicBlock b = new CosmicBlock(world, location = new WorldPosition(block.getX(), block.getY(), block.getZ()), block.getType().toString());
        singularity.events.server.world.BlockBreakEvent e = (singularity.events.server.world.BlockBreakEvent)new singularity.events.server.world.BlockBreakEvent(streamPlayer, b).fire();
        if (e.isCancelled()) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onBlockBreak(org.bukkit.event.block.BlockPlaceEvent event) {
        WorldPosition location;
        Player player = event.getPlayer();
        Block block = event.getBlock();
        CosmicPlayer streamPlayer = UserUtils.getOrCreatePlayer(player.getUniqueId().toString()).orElse(null);
        if (streamPlayer == null) {
            MessageUtils.logWarning("Failed to create CosmicPlayer for " + player.getName() + " (" + String.valueOf(player.getUniqueId()) + ")");
            return;
        }
        PlayerWorld world = new PlayerWorld(player.getWorld().getName());
        CosmicBlock b = new CosmicBlock(world, location = new WorldPosition(block.getX(), block.getY(), block.getZ()), block.getType().toString());
        BlockPlaceEvent e = (BlockPlaceEvent)new BlockPlaceEvent(streamPlayer, b).fire();
        if (e.isCancelled()) {
            event.setCancelled(true);
            return;
        }
    }

    public static boolean isMessaged() {
        return messaged;
    }

    public static void setMessaged(boolean messaged) {
        PlatformListener.messaged = messaged;
    }

    public static boolean isJoined() {
        return joined;
    }

    public static void setJoined(boolean joined) {
        PlatformListener.joined = joined;
    }

    public static BaseProcessorListener getProcessorListener() {
        return processorListener;
    }

    public static void setProcessorListener(BaseProcessorListener processorListener) {
        PlatformListener.processorListener = processorListener;
    }

    public static PaperListener getPaperListener() {
        return paperListener;
    }

    public static void setPaperListener(PaperListener paperListener) {
        PlatformListener.paperListener = paperListener;
    }

    public static class BaseProcessorListener
    implements BaseEventListener {
        public BaseProcessorListener() {
            MessageUtils.logInfo("Registered " + this.getClass().getSimpleName() + "!");
        }

        @BaseProcessor
        public void onProxiedMessageReceived(ProxyMessageInEvent event) {
            PlatformListener.setMessaged(true);
        }
    }

    public static class ProxyMessagingListener
    implements PluginMessageListener {
        public ProxyMessagingListener() {
            MessageUtils.logInfo("Registered " + this.getClass().getSimpleName() + "!");
        }

        public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, byte @NotNull [] message) {
            CosmicPlayer streamPlayer = UserUtils.getOrCreatePlayer(player.getUniqueId().toString()).orElse(null);
            if (streamPlayer == null) {
                MessageUtils.logWarning("Failed to create CosmicPlayer for " + player.getName() + " (" + String.valueOf(player.getUniqueId()) + ")");
                return;
            }
            try {
                ProxiedMessage messageIn = new ProxiedMessage(streamPlayer, true, message, channel);
                ProxyMessageInEvent e = (ProxyMessageInEvent)new ProxyMessageInEvent(messageIn).fire();
                if (e.isCancelled()) {
                    return;
                }
                SLAPI.getInstance().getProxyMessenger().receiveMessage(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

