/*
 * Decompiled with CFR 0.152.
 */
package singularity.command.context;

import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListSet;
import singularity.command.CosmicCommand;
import singularity.command.context.CommandArgument;
import singularity.command.result.CommandResult;
import singularity.data.console.CosmicSender;
import singularity.data.players.CosmicPlayer;
import singularity.utils.UserUtils;

public class CommandContext<C extends CosmicCommand> {
    private CosmicSender sender;
    private C command;
    private String label;
    private ConcurrentSkipListSet<CommandArgument> args;
    private CommandResult<?> result;

    public CommandContext(CosmicSender sender, C command, CommandResult<?> result, String ... args) {
        this.sender = sender;
        this.command = command;
        this.label = ((CosmicCommand)command).getLabel();
        this.result = result;
        this.args = CommandContext.getArgsFrom(args);
    }

    public CommandArgument getArg(int index) {
        return this.args.stream().filter(arg -> arg.getIndex() == index).findFirst().orElse(new CommandArgument());
    }

    public boolean isArgUsable(int index) {
        return this.args.stream().anyMatch(arg -> arg.getIndex() == index) && this.getArg(index).isUsable();
    }

    public boolean isConsole() {
        return this.sender.isConsole();
    }

    public boolean isPlayer() {
        return !this.isConsole();
    }

    public void sendMessage(String message, boolean format) {
        this.sender.sendMessage(message, format);
    }

    public void sendMessage(String message) {
        this.sender.sendMessage(message);
    }

    public int getArgCount() {
        return this.args.size();
    }

    public String[] getArgsArray() {
        return (String[])this.args.stream().map(CommandArgument::getContent).toArray(String[]::new);
    }

    public boolean isEmpty() {
        return this.args.isEmpty() || this.isArgUsable(0);
    }

    public boolean hasArgs() {
        return !this.isEmpty();
    }

    public boolean hasArg(int index) {
        return this.getArg(index).isEmpty();
    }

    public boolean isSenderArgUsable(int index) {
        return this.getSenderArg(index).isPresent();
    }

    public boolean isPlayerArgUsable(int index) {
        return this.getPlayerArg(index).isPresent();
    }

    public Optional<CosmicSender> getSenderArg(int index) {
        String username = this.getStringArg(index);
        return UserUtils.getOrCreateSenderByName(username);
    }

    public CosmicSender getSenderArgRequired(int index) {
        return this.getSenderArg(index).orElse(null);
    }

    public Optional<CosmicPlayer> getPlayerArg(int index) {
        String username = this.getStringArg(index);
        return UserUtils.getOrCreatePlayerByName(username);
    }

    public CosmicPlayer getPlayerArgRequired(int index) {
        return this.getPlayerArg(index).orElse(null);
    }

    public String getStringArg(int index) {
        return this.args.stream().filter(arg -> arg.getIndex() == index).findFirst().orElse(new CommandArgument()).getContent();
    }

    public Optional<Integer> getIntArg(int index) {
        try {
            return Optional.of(Integer.parseInt(this.getStringArg(index)));
        }
        catch (NumberFormatException ignored) {
            return Optional.empty();
        }
    }

    public Optional<Double> getDoubleArg(int index) {
        try {
            return Optional.of(Double.parseDouble(this.getStringArg(index)));
        }
        catch (NumberFormatException ignored) {
            return Optional.empty();
        }
    }

    public Optional<Float> getFloatArg(int index) {
        try {
            return Optional.of(Float.valueOf(Float.parseFloat(this.getStringArg(index))));
        }
        catch (NumberFormatException ignored) {
            return Optional.empty();
        }
    }

    public Optional<Long> getLongArg(int index) {
        try {
            return Optional.of(Long.parseLong(this.getStringArg(index)));
        }
        catch (NumberFormatException ignored) {
            return Optional.empty();
        }
    }

    public Optional<Short> getShortArg(int index) {
        try {
            return Optional.of(Short.parseShort(this.getStringArg(index)));
        }
        catch (NumberFormatException ignored) {
            return Optional.empty();
        }
    }

    public Optional<Byte> getByteArg(int index) {
        try {
            return Optional.of(Byte.parseByte(this.getStringArg(index)));
        }
        catch (NumberFormatException ignored) {
            return Optional.empty();
        }
    }

    public Optional<Boolean> getBooleanArg(int index) {
        try {
            return Optional.of(Boolean.parseBoolean(this.getStringArg(index)));
        }
        catch (NumberFormatException ignored) {
            return Optional.empty();
        }
    }

    public static ConcurrentSkipListSet<CommandArgument> getArgsFrom(String ... args) {
        ConcurrentSkipListSet<CommandArgument> arguments = new ConcurrentSkipListSet<CommandArgument>();
        for (int i = 0; i < args.length; ++i) {
            arguments.add(new CommandArgument(i, args[i]));
        }
        return arguments;
    }

    public static ConcurrentSkipListSet<CommandArgument> getArgsFrom(String string) {
        String[] args = string.split(" ");
        return CommandContext.getArgsFrom(args);
    }

    public CosmicSender getSender() {
        return this.sender;
    }

    public C getCommand() {
        return this.command;
    }

    public String getLabel() {
        return this.label;
    }

    public ConcurrentSkipListSet<CommandArgument> getArgs() {
        return this.args;
    }

    public CommandResult<?> getResult() {
        return this.result;
    }

    public void setSender(CosmicSender sender) {
        this.sender = sender;
    }

    public void setCommand(C command) {
        this.command = command;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setArgs(ConcurrentSkipListSet<CommandArgument> args) {
        this.args = args;
    }

    public void setResult(CommandResult<?> result) {
        this.result = result;
    }
}

