/*
 * Decompiled with CFR 0.152.
 */
package singularity.configs;

import gg.drak.thebase.lib.leonhard.storage.Config;
import gg.drak.thebase.storage.resources.flat.simple.SimpleConfiguration;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import singularity.command.CommandHandler;
import singularity.command.CosmicCommand;
import singularity.modules.CosmicModule;
import singularity.modules.ModuleLike;

public class CommandResource
extends SimpleConfiguration {
    final String identifier;
    CosmicCommand command;
    ModuleLike module;

    public CommandResource(CosmicCommand command, File parentDirectory) {
        super(command.getIdentifier() + ".yml", parentDirectory, false);
        this.identifier = command.getIdentifier();
        this.command = command;
        if (this.exists()) {
            if (this.empty()) {
                this.afterInit();
            }
        } else {
            this.afterInit();
        }
        if (!((Config)this.getResource()).getBoolean("basic.enabled") && (Double)((Config)this.getResource()).getOrDefault("DO-NOT-TOUCH.version", (Object)0.0) < 1.0) {
            this.afterInit();
        }
        this.syncCommand();
    }

    public CommandResource(CosmicModule module, CosmicCommand command, File parentDirectory) {
        this(command, parentDirectory);
        this.module = module;
    }

    public void init() {
    }

    public void afterInit() {
        this.write("DO-NOT-TOUCH.version", 1.0);
        this.write("basic.enabled", true);
        this.write("basic.label", this.command.getBase());
        this.write("basic.permissions.default", this.command.getPermission());
        this.write("basic.aliases", Arrays.stream(this.command.getAliases()).collect(Collectors.toList()));
    }

    public void syncCommand() {
        boolean enabled = ((Config)this.getResource()).getBoolean("basic.enabled");
        if (!enabled && (Double)((Config)this.getResource()).getOrDefault("DO-NOT-TOUCH.version", (Object)0.0) < 1.0) {
            enabled = true;
            this.write("basic.enabled", true);
            this.write("DO-NOT-TOUCH.version", 1.0);
        }
        String label = ((Config)this.getResource()).getString("basic.label");
        String defaultPermission = ((Config)this.getResource()).getString("basic.permissions.default");
        List aliases = ((Config)this.getResource()).getStringList("basic.aliases");
        if (this.command.isLoaded() && !enabled) {
            CommandHandler.registerStreamlineCommand(this.command);
        }
        if (!this.command.isLoaded() && enabled) {
            CommandHandler.unregisterStreamlineCommand(this.command);
        }
        this.command.setBase(label);
        this.command.setPermission(defaultPermission);
        this.command.setAliases(aliases.toArray(new String[0]));
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public CosmicCommand getCommand() {
        return this.command;
    }

    public ModuleLike getModule() {
        return this.module;
    }

    public void setCommand(CosmicCommand command) {
        this.command = command;
    }

    public void setModule(ModuleLike module) {
        this.module = module;
    }
}

