/*
 * Decompiled with CFR 0.152.
 */
package singularity.configs.given;

import gg.drak.thebase.async.AsyncUtils;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import singularity.Singularity;
import singularity.configs.given.DatabaseConfigHandler;
import singularity.configs.given.MainConfigHandler;
import singularity.configs.given.MainMessagesHandler;
import singularity.configs.given.RedisConfigHandler;
import singularity.configs.given.ServerConfigHandler;
import singularity.configs.given.whitelist.WhitelistConfig;
import singularity.data.console.CosmicSender;
import singularity.database.ConnectorSet;
import singularity.database.CoreDBOperator;
import singularity.database.servers.SavedServer;
import singularity.redis.OwnRedisClient;
import singularity.utils.UserUtils;

public class GivenConfigs {
    private static MainConfigHandler mainConfig;
    private static MainMessagesHandler mainMessages;
    private static WhitelistConfig whitelistConfig;
    private static DatabaseConfigHandler databaseConfig;
    private static ServerConfigHandler serverConfig;
    private static RedisConfigHandler redisConfig;
    private static File punishmentFolder;
    private static CoreDBOperator mainDatabase;
    private static AtomicBoolean databaseReadyAtomic;
    private static AtomicBoolean redisReadyAtomic;

    public static void init() {
        GivenConfigs.setDatabaseReadyAtomic(new AtomicBoolean(false));
        GivenConfigs.setMainConfig(new MainConfigHandler());
        GivenConfigs.setMainMessages(new MainMessagesHandler());
        GivenConfigs.setWhitelistConfig(new WhitelistConfig());
        GivenConfigs.setDatabaseConfig(new DatabaseConfigHandler());
        GivenConfigs.setServerConfig(new ServerConfigHandler());
        GivenConfigs.setRedisConfig(new RedisConfigHandler());
        AsyncUtils.executeAsync(() -> {
            try {
                ConnectorSet connectorSet = GivenConfigs.getDatabaseConfig().getConnectorSet();
                CoreDBOperator operator = new CoreDBOperator(connectorSet);
                GivenConfigs.setMainDatabase(operator);
                GivenConfigs.ensureServer();
                GivenConfigs.setDatabaseReady(true);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        });
        AsyncUtils.executeAsync(() -> {
            try {
                OwnRedisClient.init();
                GivenConfigs.setRedisReady(true);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        });
    }

    public static boolean isDatabaseReady() {
        return GivenConfigs.getDatabaseReadyAtomic() != null && GivenConfigs.getDatabaseReadyAtomic().get();
    }

    public static boolean isRedisReady() {
        return GivenConfigs.getRedisReadyAtomic() != null && GivenConfigs.getRedisReadyAtomic().get();
    }

    public static void setDatabaseReady(boolean ready) {
        if (GivenConfigs.getDatabaseReadyAtomic() == null) {
            GivenConfigs.setDatabaseReadyAtomic(new AtomicBoolean(ready));
        } else {
            GivenConfigs.getDatabaseReadyAtomic().set(ready);
        }
    }

    public static void setRedisReady(boolean ready) {
        if (GivenConfigs.getRedisReadyAtomic() == null) {
            GivenConfigs.setRedisReadyAtomic(new AtomicBoolean(ready));
        } else {
            GivenConfigs.getRedisReadyAtomic().set(ready);
        }
    }

    public static void awaitDatabaseReady() {
        while (!GivenConfigs.isDatabaseReady()) {
            Thread.onSpinWait();
        }
    }

    public static void waitUntilRedisReady() {
        while (!GivenConfigs.isRedisReady()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    public static void ensureFolders() {
        GivenConfigs.setPunishmentFolder(new File(Singularity.getInstance().getDataFolder(), "punishments" + File.separator));
        GivenConfigs.ensureFolder(GivenConfigs.getPunishmentFolder());
    }

    public static void ensureFolder(File folder) {
        if (folder == null) {
            return;
        }
        if (!folder.isDirectory()) {
            return;
        }
        folder.mkdirs();
    }

    public static void reloadData() {
        GivenConfigs.getMainConfig().reloadResource();
        GivenConfigs.getMainMessages().reloadResource();
        for (CosmicSender user : UserUtils.getLoadedSendersSet()) {
            user.save();
            user.reload();
        }
    }

    public static void ensureServer() {
        GivenConfigs.getServer().push();
    }

    public static SavedServer getServer() {
        return GivenConfigs.getServerConfig().getServer();
    }

    public static String getServerName() {
        return GivenConfigs.getServerConfig().getName();
    }

    public static void writeServer(SavedServer server) {
        GivenConfigs.getServerConfig().writeServer(server);
    }

    public static void writeServerName(String name) {
        GivenConfigs.getServerConfig().writeName(name);
    }

    public static MainConfigHandler getMainConfig() {
        return mainConfig;
    }

    public static void setMainConfig(MainConfigHandler mainConfig) {
        GivenConfigs.mainConfig = mainConfig;
    }

    public static MainMessagesHandler getMainMessages() {
        return mainMessages;
    }

    public static void setMainMessages(MainMessagesHandler mainMessages) {
        GivenConfigs.mainMessages = mainMessages;
    }

    public static WhitelistConfig getWhitelistConfig() {
        return whitelistConfig;
    }

    public static void setWhitelistConfig(WhitelistConfig whitelistConfig) {
        GivenConfigs.whitelistConfig = whitelistConfig;
    }

    public static DatabaseConfigHandler getDatabaseConfig() {
        return databaseConfig;
    }

    public static void setDatabaseConfig(DatabaseConfigHandler databaseConfig) {
        GivenConfigs.databaseConfig = databaseConfig;
    }

    public static ServerConfigHandler getServerConfig() {
        return serverConfig;
    }

    public static void setServerConfig(ServerConfigHandler serverConfig) {
        GivenConfigs.serverConfig = serverConfig;
    }

    public static RedisConfigHandler getRedisConfig() {
        return redisConfig;
    }

    public static void setRedisConfig(RedisConfigHandler redisConfig) {
        GivenConfigs.redisConfig = redisConfig;
    }

    public static File getPunishmentFolder() {
        return punishmentFolder;
    }

    public static void setPunishmentFolder(File punishmentFolder) {
        GivenConfigs.punishmentFolder = punishmentFolder;
    }

    public static CoreDBOperator getMainDatabase() {
        return mainDatabase;
    }

    public static void setMainDatabase(CoreDBOperator mainDatabase) {
        GivenConfigs.mainDatabase = mainDatabase;
    }

    public static AtomicBoolean getDatabaseReadyAtomic() {
        return databaseReadyAtomic;
    }

    public static void setDatabaseReadyAtomic(AtomicBoolean databaseReadyAtomic) {
        GivenConfigs.databaseReadyAtomic = databaseReadyAtomic;
    }

    public static AtomicBoolean getRedisReadyAtomic() {
        return redisReadyAtomic;
    }

    public static void setRedisReadyAtomic(AtomicBoolean redisReadyAtomic) {
        GivenConfigs.redisReadyAtomic = redisReadyAtomic;
    }
}

