/*
 * Decompiled with CFR 0.152.
 */
package singularity.data.console;

import java.util.Date;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import singularity.Singularity;
import singularity.configs.given.GivenConfigs;
import singularity.data.players.CosmicPlayer;
import singularity.data.players.events.CreatePlayerEvent;
import singularity.data.players.events.CreateSenderEvent;
import singularity.data.players.location.CosmicLocation;
import singularity.data.players.meta.SenderMeta;
import singularity.data.players.permissions.SenderPermissions;
import singularity.data.server.CosmicServer;
import singularity.interfaces.audiences.real.RealSender;
import singularity.loading.Loadable;
import singularity.modules.ModuleUtils;
import singularity.text.UsersReplacements;
import singularity.utils.MessageUtils;
import singularity.utils.UserUtils;

public class CosmicSender
implements Loadable<CosmicSender> {
    private String uuid;
    private Date firstJoinDate;
    private Date lastJoinDate;
    private Date lastQuitDate;
    private String currentName;
    private long playSeconds;
    private SenderMeta meta;
    private SenderPermissions permissions;
    private boolean proxyTouched;
    private boolean fullyLoaded = false;
    private boolean temporary = false;
    private UsersReplacements replacements;

    public String getIdentifier() {
        return this.getUuid();
    }

    public void setIdentifier(String identifier) {
        this.setUuid(identifier);
    }

    public CosmicSender(String uuid, boolean temporary) {
        this.uuid = uuid;
        this.temporary = temporary;
        this.firstJoinDate = new Date();
        this.lastJoinDate = new Date();
        this.currentName = "";
        this.playSeconds = 0L;
        this.meta = new SenderMeta(this);
        this.permissions = new SenderPermissions(this);
        this.replacements = new UsersReplacements(this.getUuid());
        this.proxyTouched = Singularity.isProxy();
    }

    public CosmicSender(String uuid) {
        this(uuid, false);
    }

    public CosmicSender() {
        this(GivenConfigs.getMainConfig().getConsoleDiscriminator());
        this.setCurrentName(GivenConfigs.getMainConfig().getConsoleName());
        this.augment((CompletableFuture)Singularity.getMainDatabase().loadPlayer(this.getIdentifier()), false);
    }

    public CosmicSender setCurrentName(String currentName) {
        String processed = currentName;
        if (processed == null || processed.isBlank() || processed.isEmpty()) {
            processed = Singularity.getInstance().getUserManager().getUsername(this.getUuid());
        }
        this.currentName = processed;
        return this;
    }

    public void setCurrentNameAsProper() {
        this.setCurrentName(Singularity.getInstance().getUserManager().getUsername(this.getUuid()));
    }

    @Override
    public void save(boolean async) {
        UserUtils.saveSender(this, async);
    }

    @Override
    public void load() {
        if (this instanceof CosmicPlayer) {
            UserUtils.loadPlayer((CosmicPlayer)this);
            return;
        }
        UserUtils.loadSender(this);
    }

    @Override
    public void unload() {
        UserUtils.unloadSender(this);
    }

    @Override
    public void saveAndUnload(boolean async) {
        this.save(async);
        this.unload();
    }

    @Override
    public boolean isLoaded() {
        return UserUtils.isLoaded(this.getUuid());
    }

    public void ensureLoaded() {
        if (!this.isLoaded()) {
            this.load();
        }
    }

    @Override
    public CosmicSender augment(CompletableFuture<Optional<CosmicSender>> future, boolean isGet) {
        this.fullyLoaded = false;
        future.whenComplete((optional, error) -> {
            if (error != null) {
                MessageUtils.logWarning("Failed to augment CosmicSender for UUID: " + this.getUuid(), error);
                this.fullyLoaded = true;
                return;
            }
            if (optional.isPresent()) {
                CosmicSender sender = (CosmicSender)optional.get();
                this.setUuid(sender.getUuid());
                this.setFirstJoinMillis(sender.getFirstJoinMillis());
                this.setLastJoinMillis(sender.getLastJoinMillis());
                this.setLastQuitMillis(sender.getLastQuitMillis());
                this.setCurrentName(sender.getCurrentName());
                this.addPlaySeconds(sender.getPlaySeconds());
                this.setServerName(sender.getServerName());
                this.setMeta(sender.getMeta());
                this.setPermissions(sender.getPermissions());
                if (this instanceof CosmicPlayer && sender instanceof CosmicPlayer) {
                    this.augmentMore((CosmicPlayer)sender);
                }
                this.setCurrentNameAsProper();
            } else if (!isGet) {
                this.temporary = false;
                if (this instanceof CosmicPlayer) {
                    new CreatePlayerEvent((CosmicPlayer)this).fire();
                } else {
                    new CreateSenderEvent(this).fire();
                }
                MessageUtils.logInfo("Created new CosmicPlayer for UUID: " + this.getUuid() + " (Console: " + this.isConsole() + ")");
                this.save();
            } else {
                this.unload();
                this.fullyLoaded = true;
                return;
            }
            this.ensureLoaded();
            this.fullyLoaded = true;
        });
        return this;
    }

    public void augmentMore(CosmicPlayer sender) {
    }

    public boolean isConsole() {
        return this.getUuid().equals(CosmicSender.getConsoleDiscriminator());
    }

    public void sendMessage(String message, boolean format) {
        if (format) {
            this.asReal().sendMessage(ModuleUtils.replacePlaceholders(this, message));
        } else {
            this.asReal().sendMessageRaw(message);
        }
    }

    public void sendMessage(String message) {
        this.sendMessage(message, true);
    }

    public void runCommand(String command) {
        this.asReal().runCommand(command);
    }

    public void chatAs(String message) {
    }

    public boolean hasPermission(String permission) {
        return this.asReal().hasPermission(permission);
    }

    public boolean isOnline() {
        return true;
    }

    public RealSender<?> asReal() {
        if (this instanceof CosmicPlayer) {
            return ((CosmicPlayer)this).asReal();
        }
        if (this.getUuid().equals(CosmicSender.getConsoleDiscriminator())) {
            return Singularity.getConsole();
        }
        return Singularity.getPlayerFromUuid(this.getUuid());
    }

    public CosmicServer getServer() {
        if (this.isConsole()) {
            return new CosmicServer(CosmicSender.getConsoleServer());
        }
        try {
            CosmicPlayer player = (CosmicPlayer)this;
            return player.getLocation().getServer();
        }
        catch (ClassCastException e) {
            return new CosmicServer("");
        }
    }

    public void setServer(CosmicServer server) {
        if (this.isConsole()) {
            return;
        }
        try {
            CosmicPlayer player = (CosmicPlayer)this;
            player.getLocation().setServer(server);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public String getServerName() {
        return this.getServer().getIdentifier();
    }

    public void setServerName(String serverName) {
        if (this.isConsole()) {
            return;
        }
        try {
            CosmicPlayer player = (CosmicPlayer)this;
            player.getLocation().setServerName(serverName);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public static String getConsoleDiscriminator() {
        return GivenConfigs.getMainConfig().getConsoleDiscriminator();
    }

    public static String getConsoleDisplayName() {
        return GivenConfigs.getMainConfig().getConsoleDisplayName();
    }

    public static String getConsoleName() {
        return GivenConfigs.getMainConfig().getConsoleName();
    }

    public static String getConsoleServer() {
        return GivenConfigs.getMainConfig().getConsoleServer();
    }

    public void setFirstJoinMillis(long millis) {
        if (millis == -1L) {
            this.firstJoinDate = null;
            return;
        }
        this.firstJoinDate = new Date(millis);
    }

    public void setLastJoinMillis(long millis) {
        if (millis == -1L) {
            this.lastJoinDate = null;
            return;
        }
        this.lastJoinDate = new Date(millis);
    }

    public void setLastQuitMillis(long millis) {
        if (millis == -1L) {
            this.lastQuitDate = null;
            return;
        }
        this.lastQuitDate = new Date(millis);
    }

    public long getFirstJoinMillis() {
        if (this.firstJoinDate == null) {
            return -1L;
        }
        return this.firstJoinDate.getTime();
    }

    public void setFirstJoinNull() {
        this.firstJoinDate = null;
    }

    public long getLastJoinMillis() {
        if (this.lastJoinDate == null) {
            return -1L;
        }
        return this.lastJoinDate.getTime();
    }

    public void setLastJoinNull() {
        this.lastJoinDate = null;
    }

    public long getLastQuitMillis() {
        if (this.lastQuitDate == null) {
            return -1L;
        }
        return this.lastQuitDate.getTime();
    }

    public void setLastQuitNull() {
        this.lastQuitDate = null;
    }

    public String getDisplayName() {
        if (!this.getMeta().getFull().isEmpty() && !this.getMeta().getFull().isBlank()) {
            return this.getMeta().getFull();
        }
        return this.isConsole() ? CosmicSender.getConsoleDisplayName() : UserUtils.getPrefix(this) + (this.getMeta().getNickname().isEmpty() || this.getMeta().getNickname().isBlank() ? this.getCurrentName() : this.getMeta().getNickname()) + UserUtils.getSuffix(this);
    }

    public void addPlaySeconds(long amount) {
        this.playSeconds += amount;
    }

    public void removePlaySecond(long amount) {
        this.playSeconds -= amount;
    }

    public void addTag(String tag) {
        this.getMeta().addTag(tag);
    }

    public void removeTag(String tag) {
        this.getMeta().removeTag(tag);
    }

    public void setPermission(String permission) {
        this.getPermissions().addPermission(permission);
    }

    public void removePermission(String permission) {
        this.getPermissions().removePermission(permission);
    }

    public void reload() {
    }

    public void teleport(CosmicPlayer player) {
        ModuleUtils.teleport(this, player);
    }

    public void teleport(CosmicLocation location) {
        ModuleUtils.teleport(this, location);
    }

    public void connect(CosmicServer server) {
        if (server == null) {
            MessageUtils.logWarning("Cannot connect to null server for player " + this.getUuid() + ".");
            return;
        }
        ModuleUtils.connect(this, server);
    }

    public void connect(CosmicSender other) {
        this.connect(other.getServer());
    }

    public void connect(String serverName) {
        if (serverName == null || serverName.isEmpty()) {
            MessageUtils.logWarning("Cannot connect to null server for player " + this.getUuid() + ".");
            return;
        }
        ModuleUtils.connect(this, serverName);
    }

    public String getUuid() {
        return this.uuid;
    }

    public Date getFirstJoinDate() {
        return this.firstJoinDate;
    }

    public Date getLastJoinDate() {
        return this.lastJoinDate;
    }

    public Date getLastQuitDate() {
        return this.lastQuitDate;
    }

    public String getCurrentName() {
        return this.currentName;
    }

    public long getPlaySeconds() {
        return this.playSeconds;
    }

    public SenderMeta getMeta() {
        return this.meta;
    }

    public SenderPermissions getPermissions() {
        return this.permissions;
    }

    public boolean isProxyTouched() {
        return this.proxyTouched;
    }

    @Override
    public boolean isFullyLoaded() {
        return this.fullyLoaded;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public UsersReplacements getReplacements() {
        return this.replacements;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setFirstJoinDate(Date firstJoinDate) {
        this.firstJoinDate = firstJoinDate;
    }

    public void setLastJoinDate(Date lastJoinDate) {
        this.lastJoinDate = lastJoinDate;
    }

    public void setLastQuitDate(Date lastQuitDate) {
        this.lastQuitDate = lastQuitDate;
    }

    public void setPlaySeconds(long playSeconds) {
        this.playSeconds = playSeconds;
    }

    public void setMeta(SenderMeta meta) {
        this.meta = meta;
    }

    public void setPermissions(SenderPermissions permissions) {
        this.permissions = permissions;
    }

    public void setProxyTouched(boolean proxyTouched) {
        this.proxyTouched = proxyTouched;
    }

    @Override
    public void setFullyLoaded(boolean fullyLoaded) {
        this.fullyLoaded = fullyLoaded;
    }

    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }

    public void setReplacements(UsersReplacements replacements) {
        this.replacements = replacements;
    }
}

