/*
 * Decompiled with CFR 0.152.
 */
package singularity.data.uuid;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicReference;
import singularity.Singularity;
import singularity.data.uuid.UuidInfo;

public class UuidManager {
    private static ConcurrentSkipListSet<UuidInfo> uuids = new ConcurrentSkipListSet();

    public static void registerUuid(UuidInfo uuidInfo) {
        if (uuids.contains(uuidInfo)) {
            UuidManager.unregisterUuid(uuidInfo);
        }
        uuids.add(uuidInfo);
    }

    public static Optional<UuidInfo> unregisterUuid(UuidInfo uuidInfo) {
        if (!uuids.contains(uuidInfo)) {
            return Optional.empty();
        }
        uuids.removeIf(uuidInfo1 -> uuidInfo1.getUuid().equals(uuidInfo.getUuid()));
        return Optional.of(uuidInfo);
    }

    public static Optional<UuidInfo> getUuid(String uuid) {
        return uuids.stream().filter(uuidInfo -> uuidInfo.getUuid().equals(uuid)).findFirst();
    }

    public static Optional<UuidInfo> unregister(String uuid) {
        AtomicReference uuidInfo = new AtomicReference(Optional.empty());
        UuidManager.getUuid(uuid).ifPresent(u -> uuidInfo.set(UuidManager.unregisterUuid(u)));
        return uuidInfo.get();
    }

    public static void registerAll(ConcurrentSkipListSet<UuidInfo> set2) {
        uuids.addAll(set2);
    }

    public static void unregisterAll(ConcurrentSkipListSet<UuidInfo> set2) {
        set2.forEach(UuidManager::unregisterUuid);
    }

    public static void clear() {
        UuidManager.getUuids().forEach(ui -> {
            ui.save();
            ui.unregister();
        });
    }

    public static Optional<UuidInfo> getFromName(String name) {
        AtomicReference uuidInfo = new AtomicReference(Optional.empty());
        UuidManager.getUuids().forEach(ui -> {
            if (ui.getNamesCaseInsensitive().contains(name.toLowerCase())) {
                uuidInfo.set(Optional.of(ui));
            }
        });
        return uuidInfo.get();
    }

    public static Optional<String> getUuidFromName(String name) {
        return UuidManager.getFromName(name).map(UuidInfo::getUuid);
    }

    public static String makeDashedUUID(String uuid) {
        if (uuid.length() != 32) {
            return uuid;
        }
        return uuid.substring(0, 8) + "-" + uuid.substring(8, 12) + "-" + uuid.substring(12, 16) + "-" + uuid.substring(16, 20) + "-" + uuid.substring(20);
    }

    public static void cachePlayer(String uuid, String name, String ip) {
        CompletableFuture.runAsync(() -> {
            Optional<UuidInfo> infoOptional = UuidManager.getUuid(uuid);
            if (infoOptional.isEmpty()) {
                Optional<UuidInfo> optional = Singularity.getMainDatabase().loadUuidInfo(uuid).join();
                if (optional.isEmpty()) {
                    UuidInfo u = new UuidInfo(uuid, name, ip);
                    u.register();
                    u.save();
                } else {
                    UuidInfo u = optional.get();
                    u.register();
                    u.addName(name);
                    u.addIp(ip);
                    u.save();
                }
            } else {
                UuidInfo u = infoOptional.get();
                u.register();
                u.addName(name);
                u.addIp(ip);
                u.save();
            }
        });
    }

    public static ConcurrentSkipListSet<UuidInfo> getUuids() {
        return uuids;
    }

    public static void setUuids(ConcurrentSkipListSet<UuidInfo> uuids) {
        UuidManager.uuids = uuids;
    }
}

