/*
 * Decompiled with CFR 0.152.
 */
package singularity.loading;

import gg.drak.thebase.objects.Identifiable;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import singularity.data.console.CosmicSender;
import singularity.data.players.CosmicPlayer;
import singularity.utils.UserUtils;

public interface Loadable<L>
extends Identifiable {
    public boolean isFullyLoaded();

    public void setFullyLoaded(boolean var1);

    public void save(boolean var1);

    default public void save() {
        this.save(true);
    }

    public L augment(CompletableFuture<Optional<L>> var1, boolean var2);

    default public L augment(CompletableFuture<Optional<L>> loader) {
        return this.augment(loader, false);
    }

    public void unload();

    public void load();

    public boolean isLoaded();

    default public void saveAndUnload(boolean async) {
        this.save(async);
        this.unload();
    }

    default public void saveAndUnload() {
        this.saveAndUnload(true);
    }

    default public Loadable<L> waitUntilFullyLoaded() {
        while (!this.isFullyLoaded()) {
            Thread.onSpinWait();
        }
        return this;
    }

    default public <T extends Loadable<L>> T waitUntilFullyLoadedTyped() {
        try {
            return (T)this.waitUntilFullyLoaded();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    default public void onceFullyLoaded(Consumer<Loadable<L>> consumer) {
        consumer.accept(this.waitUntilFullyLoaded());
    }

    default public <T extends Loadable<L>> void onceFullyLoadedTyped(Consumer<T> consumer) {
        consumer.accept(this.waitUntilFullyLoadedTyped());
    }

    default public Optional<CosmicSender> asSender() {
        return UserUtils.getOrGetSender(this.getIdentifier());
    }

    default public Optional<CosmicSender> asSenderOrCreate() {
        return UserUtils.getOrCreateSender(this.getIdentifier());
    }

    default public Optional<CosmicPlayer> asPlayer() {
        return UserUtils.getOrGetPlayer(this.getIdentifier());
    }

    default public Optional<CosmicPlayer> asPlayerOrCreate() {
        return UserUtils.getOrCreatePlayer(this.getIdentifier());
    }
}

