/*
 * Decompiled with CFR 0.152.
 */
package singularity.loading;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListSet;
import singularity.Singularity;
import singularity.data.console.CosmicSender;
import singularity.database.CoreDBOperator;
import singularity.database.modules.DBKeeper;
import singularity.loading.Loadable;

public abstract class Loader<L extends Loadable<L>> {
    public ConcurrentSkipListSet<L> loaded = new ConcurrentSkipListSet();

    public abstract DBKeeper<L> getKeeper();

    public static CoreDBOperator getOperator() {
        return Singularity.getMainDatabase();
    }

    public CompletableFuture<Boolean> userExists(String identifier) {
        return this.getKeeper().exists(identifier);
    }

    public abstract L getConsole();

    public Optional<L> get(String identifier) {
        if (identifier == null) {
            return Optional.empty();
        }
        if (identifier.equals(CosmicSender.getConsoleDiscriminator())) {
            return Optional.of(this.getConsole());
        }
        return this.getLoaded().stream().filter(a -> a.getIdentifier().equals(identifier)).findFirst();
    }

    public L load(L toLoad) {
        if (this.isLoaded(toLoad.getIdentifier())) {
            return (L)((Loadable)this.get(toLoad.getIdentifier()).get());
        }
        this.getLoaded().add(toLoad);
        this.fireLoadEvents(toLoad);
        return toLoad;
    }

    public abstract void fireLoadEvents(L var1);

    public abstract L instantiate(String var1);

    public L createNew(String identifier) {
        L created = this.instantiate(identifier);
        created.save();
        this.fireCreateEvents(created);
        return this.load(created);
    }

    public abstract void fireCreateEvents(L var1);

    public CompletableFuture<L> getOrCreateAsync(String identifier) {
        return CompletableFuture.supplyAsync(() -> {
            Optional<L> optional = this.getKeeper().load(identifier).join();
            if (optional.isPresent()) {
                return this.load((Loadable)optional.get());
            }
            return this.createNew(identifier);
        });
    }

    public boolean isLoaded(String identifier) {
        return this.get(identifier).isPresent();
    }

    public Optional<L> getOrLoad(String identifier) {
        CompletableFuture.runAsync(() -> {
            if (this.isLoaded(identifier)) {
                return;
            }
            Loadable created = (Loadable)this.getOrCreateAsync(identifier).join();
            this.load(created);
        });
        return this.get(identifier);
    }

    public L getOrCreate(L sender) {
        return this.getOrCreate(sender.getIdentifier());
    }

    public L getOrCreate(String identifier) {
        Optional<L> optional = this.getOrLoad(identifier);
        if (optional.isPresent()) {
            return (L)((Loadable)optional.get());
        }
        if (identifier.equals(CosmicSender.getConsoleDiscriminator())) {
            return this.getConsole();
        }
        CompletableFuture<Optional<L>> loader = this.load(identifier);
        L toGet = this.createNew(identifier);
        this.load(toGet);
        return (L)((Loadable)toGet.augment(loader));
    }

    public CompletableFuture<Optional<L>> load(String uuid) {
        return this.getKeeper().load(uuid);
    }

    public void unload(String identifier) {
        Optional<L> optional = this.get(identifier);
        if (optional.isEmpty()) {
            return;
        }
        Loadable loadable = (Loadable)optional.get();
        loadable.save();
        this.getLoaded().remove(loadable);
    }

    public void unload(L loadable) {
        this.unload(loadable.getIdentifier());
    }

    public boolean isLoaded(L loadable) {
        return this.isLoaded(loadable.getIdentifier());
    }

    public ConcurrentSkipListSet<L> getLoaded() {
        return this.loaded;
    }

    public void setLoaded(ConcurrentSkipListSet<L> loaded) {
        this.loaded = loaded;
    }
}

