/*
 * Decompiled with CFR 0.152.
 */
package singularity.objects;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Collectors;
import singularity.data.players.CosmicPlayer;

public class CosmicServerInfo {
    private final String identifier;
    private String name;
    private String motd;
    private String address;
    private ConcurrentSkipListSet<String> onlineUsers;

    public CosmicServerInfo(String identifier, String name, String motd, String address, ConcurrentSkipListSet<String> onlineUsers) {
        this.identifier = identifier;
        this.name = name;
        this.motd = motd;
        this.address = address;
        this.onlineUsers = onlineUsers;
    }

    public void updateUsersTo(List<CosmicPlayer> users) {
        this.onlineUsers = new ConcurrentSkipListSet();
        users.forEach(a -> this.onlineUsers.add(a.getUuid()));
    }

    public void updateUsersTo(CosmicPlayer ... users) {
        this.updateUsersTo(Arrays.stream(users).collect(Collectors.toList()));
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public String getMotd() {
        return this.motd;
    }

    public String getAddress() {
        return this.address;
    }

    public ConcurrentSkipListSet<String> getOnlineUsers() {
        return this.onlineUsers;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMotd(String motd) {
        this.motd = motd;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setOnlineUsers(ConcurrentSkipListSet<String> onlineUsers) {
        this.onlineUsers = onlineUsers;
    }
}

