/*
 * Decompiled with CFR 0.152.
 */
package singularity.scheduler;

import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import singularity.modules.ModuleLike;
import singularity.scheduler.ModuleRunnable;

public class ModuleTaskManager {
    public ConcurrentHashMap<ModuleLike, TreeMap<Integer, ModuleRunnable>> currentRunnables = new ConcurrentHashMap();

    public void start(ModuleRunnable moduleRunnable) {
        TreeMap<Integer, ModuleRunnable> map = this.currentRunnables.get(moduleRunnable.getModule());
        if (map == null) {
            map = new TreeMap();
        }
        map.put(moduleRunnable.getIndex(), moduleRunnable);
        this.currentRunnables.put(moduleRunnable.getModule(), map);
    }

    public void cancel(ModuleRunnable moduleRunnable) {
        TreeMap<Integer, ModuleRunnable> map = this.currentRunnables.get(moduleRunnable.getModule());
        if (map == null) {
            map = new TreeMap();
        }
        map.remove(moduleRunnable.getIndex());
        this.currentRunnables.put(moduleRunnable.getModule(), map);
    }

    public void cancelAll(ModuleLike module) {
        for (ModuleRunnable runnable : this.currentRunnables.get(module).values()) {
            runnable.cancel();
        }
    }

    public void tick() {
        for (ModuleLike module : this.currentRunnables.keySet()) {
            for (ModuleRunnable runnable : this.currentRunnables.get(module).values()) {
                runnable.tick();
            }
        }
    }
}

