/*
 * Decompiled with CFR 0.152.
 */
package singularity.text;

import gg.drak.thebase.lib.re2j.Matcher;
import gg.drak.thebase.lib.re2j.Pattern;
import gg.drak.thebase.utils.MatcherUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentSkipListSet;
import singularity.text.HexPolicy;
import singularity.utils.MessageUtils;

public class TextManager {
    private static ConcurrentSkipListSet<HexPolicy> hexPolicies = new ConcurrentSkipListSet();

    public static void registerHexPolicy(HexPolicy resulter) {
        hexPolicies.add(resulter);
        MessageUtils.logInfo("Registered HexPolicy with starter '" + resulter.getStarter() + "' and ender '" + resulter.getEnder() + "'.");
    }

    public static void registerHexPolicy(String starter, String ender) {
        TextManager.registerHexPolicy(new HexPolicy(starter, ender));
    }

    public static void unregisterHexPolicy(HexPolicy resulter) {
        TextManager.unregisterHexPolicy(resulter.getIdentifiably());
    }

    public static void unregisterHexPolicy(String identifiably) {
        hexPolicies.removeIf(resulter -> resulter.getIdentifiably().equals(identifiably));
    }

    public static List<String> extractHexCodes(String input, HexPolicy hexPolicy) {
        ArrayList<String> hexCodes = new ArrayList<String>();
        String regex = (Objects.equals(hexPolicy.getStarter(), "") || hexPolicy.getStarter() == null ? "" : MatcherUtils.makeLiteral((String)hexPolicy.getStarter())) + "([a-fA-F0-9]{6})" + (Objects.equals(hexPolicy.getEnder(), "") || hexPolicy.getEnder() == null ? "" : MatcherUtils.makeLiteral((String)hexPolicy.getEnder()));
        Pattern pattern = Pattern.compile((String)regex);
        Matcher matcher = pattern.matcher((CharSequence)input);
        while (matcher.find()) {
            hexCodes.add(matcher.group(1));
        }
        return hexCodes;
    }

    public static List<String> extractJsonStrings(String input, String startMarker) {
        ArrayList<String> jsonStrings = new ArrayList<String>();
        int index = 0;
        while ((index = input.indexOf(startMarker, index)) != -1) {
            int i;
            int braceCount = 0;
            for (i = index + startMarker.length(); i < input.length(); ++i) {
                char c = input.charAt(i);
                if (c == '{') {
                    ++braceCount;
                    continue;
                }
                if (c == '}' && --braceCount == 0) break;
            }
            if (braceCount == 0) {
                jsonStrings.add(input.substring(index + startMarker.length(), i + 1));
            }
            index = i + 1;
        }
        return jsonStrings;
    }

    public static ConcurrentSkipListSet<HexPolicy> getHexPolicies() {
        return hexPolicies;
    }

    public static void setHexPolicies(ConcurrentSkipListSet<HexPolicy> hexPolicies) {
        TextManager.hexPolicies = hexPolicies;
    }
}

